% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distiller.R
\name{distill}
\alias{distill}
\title{Builds surrogate model from an interpreter object based on the univariate
  PDP functions of the original model.}
\usage{
distill(
  object,
  center.mean = TRUE,
  features = 1:length(object$features),
  cv = FALSE,
  snap.grid = TRUE,
  snap.train = TRUE,
  params.glmnet = list(),
  params.cv.glmnet = list()
)
}
\arguments{
\item{object}{The Interpreter object}

\item{center.mean}{Boolean value that determines whether to center each column
of predictions by their respective means. Default is TRUE}

\item{features}{The indices of the features in the Interpreter's features that we want
to include as PDP functions in the distilled model.}

\item{cv}{Boolean that indicates whether we want to cross-validate our fitted coefficients
with a regularizer. This should only be done when regularizing coefficients.}

\item{snap.grid}{Boolean function that determines whether the model recalculates
each value predicted or uses an approximation from previous
calculations. When this parameter is set to TRUE, we approximate
the predicted values with prevoius calculations. Default is TRUE.}

\item{snap.train}{Boolean that determines whether we use the training data or the
equally spaced grid points. By default, this is true, which means
we snap to grid points as determined by the training data's marginal
distribution.}

\item{params.glmnet}{Optional list of parameters to pass to glmnet while fitting
PDP curves to resemble the original predictions. By specifying
parameters, one can do lasso or ridge regression.}

\item{params.cv.glmnet}{Optional list of parameters to pass to cv.glmnet while fitting
PDP curves to resemble the original predictions. By specifying
parameters, one can do lasso or ridge regression.}
}
\value{
A surrogate class object that can be used for predictions
}
\description{
Builds a surrogate model from the PDP functions
}
\note{
For further details, please refer to the vignette for this method, which includes
usage examples.
}
