% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/momentum_model_frame.R
\name{momentum_model_frame}
\alias{momentum_model_frame}
\title{Dissimilarity Model Frame}
\usage{
momentum_model_frame(
  response_df = NULL,
  predictors_df = NULL,
  composite_predictors = NULL,
  scale = TRUE,
  distance = "euclidean"
)
}
\arguments{
\item{response_df}{(required, data frame) output of \code{\link[=momentum]{momentum()}}, \code{\link[=momentum_ls]{momentum_ls()}}, or \code{\link[=momentum_dtw]{momentum_dtw()}}. Default: NULL}

\item{predictors_df}{(required, data frame or sf data frame) data frame with numeric predictors for the the model frame. Must have a column with the time series names in \code{response_df$x} and \code{response_df$y}. If \code{sf} data frame, the column "geographic_distance" with distances between pairs of time series is added to the model frame. Default: NULL}

\item{composite_predictors}{(optional, list) list defining composite predictors. For example, \code{composite_predictors = list(a = c("b", "c"))} uses the columns \code{"b"} and \code{"c"} from \code{predictors_df} to generate the predictor \code{a} as the multivariate distance between \code{"b"} and \code{"c"} for each pair of time series in \code{response_df}. Default: NULL}

\item{scale}{(optional, logical) if TRUE, all predictors are scaled and centered with \code{\link[=scale]{scale()}}. Default: TRUE}

\item{distance}{(optional, string) Method to compute the distance between predictor values for all pairs of time series in \code{response_df}. Default: "euclidean".}
}
\value{
data frame: with the attribute "predictors".
}
\description{
This function generates a model frame for statistical or machine learning analysis from these objects:

\itemize{
\item: Dissimilarity data frame generated by \code{\link[=momentum]{momentum()}}, \code{\link[=momentum_ls]{momentum_ls()}}, or \code{\link[=momentum_dtw]{momentum_dtw()}}. The output model frame will have as many rows as this data frame.
\item: Data frame with static descriptors of the time series. These descriptors are converted to distances between pairs of time series via \code{\link[=distance_matrix]{distance_matrix()}}.
\item: List defining composite predictors. This feature allows grouping together predictors that have a common meaning. For example, \verb{composite_predictors = list(temperature = c("temperature_mean", "temperature_min", "temperature_max")} generates a new predictor named "temperature", which results from computing the multivariate distances between the vectors of temperature variables of each pair of time series. Predictors in one of such groups will be scaled before distance computation if their maximum standard deviations differ by a factor of 10 or more.
}

The resulting data frame contains the following columns:
\itemize{
\item \code{x} and \code{y}: names of the pair of time series represented in the row.
\item response columns.
\item predictors columns: representing the distance between the values of the given static predictor between \code{x} and \code{y}.
\item (optional) \code{geographic_distance}: If \code{predictors_df} is an \code{sf} data frame, then geographic distances are computed via \code{\link[sf:geos_measures]{sf::st_distance()}}.
}

This function supports a parallelization setup via \code{\link[future:plan]{future::plan()}}.
}
\examples{

#Fagus sylvatica dynamics in Europe
tsl <- tsl_initialize(
  x = fagus_dynamics,
  name_column = "name",
  time_column = "time"
)

#dissimilarity analysis
df <- momentum_ls(tsl = tsl)

#generate model frame
model_frame <- momentum_model_frame(
  response_df = df,
  predictors_df = fagus_coordinates,
  scale = TRUE
)

head(model_frame)

#names of response and predictors
#and an additive formula
#are stored as attributes
attributes(model_frame)$predictors

}
\seealso{
Other momentum_support: 
\code{\link{momentum_aggregate}()},
\code{\link{momentum_boxplot}()},
\code{\link{momentum_spatial}()},
\code{\link{momentum_stats}()},
\code{\link{momentum_to_wide}()}
}
\concept{momentum_support}
