% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{eemian_pollen}
\alias{eemian_pollen}
\title{Pollen Counts of Nine Interglacial Sites in Central Europe}
\format{
data frame with 24 columns and 376 rows.
}
\usage{
data(eemian_pollen)
}
\description{
Pollen counts of nine interglacial sites in central Europe.

Site coordinates for this dataset are in \link{eemian_coordinates}.
}
\examples{
data("eemian_pollen")

#to time series list
tsl <- tsl_initialize(
  x = eemian_pollen,
  name_column = "name",
  time_column = "time"
)

#time series plot
if(interactive()){

 tsl_plot(
  tsl = tsl_subset(
    tsl = tsl,
    names = 1:3
    ),
  columns = 2,
  guide_columns = 2
  )

}

}
\seealso{
Other example_data: 
\code{\link{albatross}},
\code{\link{cities_coordinates}},
\code{\link{cities_temperature}},
\code{\link{covid_counties}},
\code{\link{covid_prevalence}},
\code{\link{eemian_coordinates}},
\code{\link{fagus_coordinates}},
\code{\link{fagus_dynamics}},
\code{\link{honeycomb_climate}},
\code{\link{honeycomb_polygons}}
}
\concept{example_data}
\keyword{datasets}
