% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distantia_ls.R
\name{distantia_ls}
\alias{distantia_ls}
\title{Lock-Step Dissimilarity Analysis of Time Series Lists}
\usage{
distantia_ls(tsl = NULL, distance = "euclidean")
}
\arguments{
\item{tsl}{(required, time series list) list of zoo time series. Default: NULL}

\item{distance}{(optional, character vector) name or abbreviation of the distance method. Valid values are in the columns "names" and "abbreviation" of the dataset \link{distances}. Default: "euclidean".}
}
\value{
data frame:
\itemize{
\item \code{x}: time series name.
\item \code{y}: time series name.
\item \code{distance}: name of the distance metric.
\item \code{psi}: psi dissimilarity of the sequences \code{x} and \code{y}.
}
}
\description{
Minimalistic but slightly faster version of \code{\link[=distantia]{distantia()}} to compute lock-step dissimilarity scores.
}
\examples{


#load fagus_dynamics as tsl
#global centering and scaling
tsl <- tsl_initialize(
  x = fagus_dynamics,
  name_column = "name",
  time_column = "time"
) |>
  tsl_transform(
    f = f_scale_global
  )

if(interactive()){
  tsl_plot(
    tsl = tsl,
    guide_columns = 3
    )
}

#lock-step dissimilarity analysis
df_ls <- distantia_ls(
  tsl = tsl,
  distance = "euclidean"
)

df_ls

}
\seealso{
Other distantia: 
\code{\link{distantia}()},
\code{\link{distantia_dtw}()},
\code{\link{distantia_dtw_plot}()}
}
\concept{distantia}
