% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflowTransfer.R
\name{workflowTransfer}
\alias{workflowTransfer}
\title{Transfers an attribute (time, age, depth) from one sequence to another}
\usage{
workflowTransfer(
  sequences = NULL,
  grouping.column = NULL,
  time.column = NULL,
  exclude.columns = NULL,
  method = "manhattan",
  transfer.what = NULL,
  transfer.from = NULL,
  transfer.to = NULL,
  mode = "direct",
  plot = FALSE
  )
}
\arguments{
\item{sequences}{dataframe with multiple sequences identified by a grouping column generated by \code{\link{prepareSequences}}.}

\item{grouping.column}{character string, name of the column in \code{sequences} to be used to identify separates sequences within the file.}

\item{time.column}{character string, name of the column with time/depth/rank data.}

\item{exclude.columns}{character string or character vector with column names in \code{sequences} to be excluded from the analysis.}

\item{method}{character string naming a distance metric. Valid entries are: "manhattan", "euclidean", "chi", and "hellinger". Invalid entries will throw an error.}

\item{transfer.what}{character string, column of \code{sequences} with the attribute to be transferred. If empty or ill-defined, \code{time.column} is used instead if available.}

\item{transfer.from}{character string, group available in \code{grouping.column} identifying the sequence from which to take the attribute values.}

\item{transfer.to}{character string, group available in \code{grouping.column} identifying the sequence to which transfer the attribute values.}

\item{mode}{character string, one of: "direct" (default), "interpolate".}

\item{plot}{boolean, if \code{TRUE}, plots the distance matrix and the least-cost path.}
}
\value{
A dataframe with the sequence \code{transfer.to}, with a column named after \code{transfer.what} with the attribute values.
}
\description{
Transfers an attribute (generally time/age, but any others are possible) from one sequence (defined by the argument \code{transfer.from}) to another (defined by the argument \code{transfer.to}) lacking it. The transference of the attribute is based on the following assumption: similar samples have similar attributes. This assumption might not hold for noisy multivariate time-series. Attribute transference can be done in two different ways (defined by the \code{mode} argument):
\itemize{
\item \emph{Direct}: transfers the selected attribute between samples with the maximum similarity. This option will likely generate duplicated attribute values in the output.
\item \emph{Interpolate}: obtains new attribute values through weighted interpolation, being the weights derived from the distances between samples
}
}
\examples{

\donttest{

#loading sample dataset
data(pollenGP)
#subset pollenGP to make a shorter dataset
pollenGP <- pollenGP[1:50, ]

#generating a subset of pollenGP
set.seed(10)
pollenX <- pollenGP[sort(sample(1:50, 40)), ]

#we separate the age column
pollenX.age <- pollenX$age

#and remove the age values from pollenX
pollenX$age <- NULL
pollenX$depth <- NULL

#removing some samples from pollenGP
#so pollenX is not a perfect subset of pollenGP
pollenGP <- pollenGP[-sample(1:50, 10), ]

#prepare sequences
GP.X <- prepareSequences(
  sequence.A = pollenGP,
  sequence.A.name = "GP",
  sequence.B = pollenX,
  sequence.B.name = "X",
  grouping.column = "id",
  time.column = "age",
  exclude.columns = "depth",
  transformation = "none"
  )

#transferring age
X.new <- workflowTransfer(
 sequences = GP.X,
 grouping.column = "id",
 time.column = "age",
 method = "manhattan",
 transfer.what = "age",
 transfer.from = "GP",
 transfer.to = "X",
 mode = "interpolated"
 )

}

}
\author{
Blas Benito <blasbenito@gmail.com>
}
