% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get1dFrom2d.R
\name{get1dFrom2d}
\alias{get1dFrom2d}
\title{2D-indexing to 1D-indexing}
\usage{
get1dFrom2d(i,j, N)
}
\arguments{
\item{i}{An integer specifying the row index}

\item{j}{An integer specifying the column index - must be different from i as "dist" object does not store the diagonal entries.}

\item{N}{The number of observations in the original data matrix}
}
\value{
An integer specifying the 1d index
}
\description{
Efficiently computes 1D-indexing from 2D-indexing
}
\details{
Converts 2D indexing (a row-column pair) into 1D indexing (as used in R's "dist" objects), given the number
of observations N.
}
\examples{
N = 5
for(i in 1:4){ 
  for(j in (i+1):5){
    print(get1dFrom2d(i,j,N))
  }
}

}
\author{
Minh Long Nguyen \email{edelweiss611428@gmail.com}
}
