% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispRity.metric.R
\name{get.ancestors}
\alias{get.ancestors}
\title{Get ancestors}
\usage{
get.ancestors(tip, tree, full = TRUE)
}
\arguments{
\item{tip}{A tip (or node) index.}

\item{tree}{A tree topology of class \code{"phylo"}.}

\item{full}{Whether to output the direct ancestor only (\code{FALSE}) or the full list of ancestors to the root (\code{TRUE} - default)}
}
\value{
A \code{integer} vector of ancestor(s).
}
\description{
Gets the list of ancestors (parents) from a tip or a node (modified from \code{\link[phytools]{getParent}})
}
\examples{
## A random tree
tree <- rtree(10)
## Get the ancestors of the first tip
get.ancestors(1, tree)

}
\seealso{
\code{\link{ancestral.dist}}, \code{\link{nodes.coordinates}}, \code{\link[phytools]{getParent}}
}
\author{
Thomas Guillerme
}
