% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.disk.frame.r
\name{as.disk.frame}
\alias{as.disk.frame}
\title{Make a data.frame into a disk.frame}
\usage{
as.disk.frame(df, outdir = tempfile(fileext = ".df"),
  nchunks = recommend_nchunks(df), overwrite = FALSE, shardby = NULL,
  compress = 50, ...)
}
\arguments{
\item{df}{a disk.frame}

\item{outdir}{the output directory}

\item{nchunks}{number of chunks}

\item{overwrite}{if TRUE the outdir will be overwritten, if FALSE it will throw an error if the directory is not empty}

\item{shardby}{The shardkey}

\item{compress}{the compression level 0-100; 100 is highest}

\item{...}{passed to output_disk.frame}
}
\description{
Make a data.frame into a disk.frame
}
\examples{
# write to temporary location
cars.df = as.disk.frame(cars) 

# specify a different path in the temporary folder, you are free to choose a different folder
cars_new_location.df = as.disk.frame(cars, outdir = file.path(tempdir(), "some_path.df"))

# specify a different number of chunks
# this writes to tempdir() by default
cars_chunks.df = as.disk.frame(cars, nchunks = 4, overwrite = TRUE) 

# clean up
delete(cars.df)
delete(cars_new_location.df)
delete(cars_chunks.df)
}
