% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/market_fit.R
\name{vcov,market_fit-method}
\alias{vcov,market_fit-method}
\title{Variance-covariance matrix for a fitted market model.}
\usage{
\S4method{vcov}{market_fit}(object)
}
\arguments{
\item{object}{A fitted model object.}
}
\value{
A matrix of covariances for the estimated model coefficients.
}
\description{
Returns the variance-covariance matrix of the estimated coefficients for
the fitted model. Specializes the \code{\link[stats]{vcov}} function for
fitted market models.
}
\examples{
\donttest{
# estimate a model using the houses dataset
fit <- diseq_deterministic_adjustment(
  HS | RM | ID | TREND ~
  RM + TREND + W + CSHS + L1RM + L2RM + MONTH |
  RM + TREND + W + L1RM + MA6DSF + MA3DHF + MONTH,
  fair_houses(),  correlated_shocks = FALSE,
  estimation_options = list(control = list(maxit = 1e+6)))

# access the variance-covariance matrix
head(vcov(fit))
}
}
