% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diseq_basic.R
\docType{class}
\name{diseq_basic-class}
\alias{diseq_basic-class}
\title{Basic disequilibrium model with unknown sample separation.}
\description{
The basic disequilibrium model consists of three equations. Two of them are
the demand and supply equations. In addition, the model replaces the market clearing condition
with the short side rule. The model is estimated using full information maximum likelihood.

\deqn{D_{nt} = X_{d,nt}'\beta_{d} + u_{d,nt},}
\deqn{S_{nt} = X_{s,nt}'\beta_{s} + u_{s,nt},}
\deqn{Q_{nt} = \min\{D_{nt},S_{nt}\}.}
}
\examples{
simulated_data <- simulate_model_data(
  "diseq_basic", 500, 3, # model type, observed entities, observed time points
  -0.9, 8.9, c(0.3, -0.2), c(-0.03, -0.01), # demand coefficients
  0.9, 4.2, c(0.03), c(-0.05, 0.02) # supply coefficients
)

# initialize the model
model <- new(
  "diseq_basic", # model type
  c("id", "date"), "Q", "P", # keys, quantity, and price variables
  "P + Xd1 + Xd2 + X1 + X2", "P + Xs1 + X1 + X2", # equation specifications
  simulated_data, # data
  correlated_shocks = TRUE # allow shocks to be correlated
)
}
