% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_diseasystore.R
\name{test_diseasystore}
\alias{test_diseasystore}
\title{Test a given diseasy store}
\usage{
test_diseasystore(
  diseasystore_generator = NULL,
  conn_generator = NULL,
  data_files = NULL,
  target_schema = "test_ds",
  test_start_date = NULL,
  ...
)
}
\arguments{
\item{diseasystore_generator}{(\verb{Diseasystore*})\cr
The diseasystore R6 class generator to test.}

\item{conn_generator}{(\code{function})\cr
Function that generates a \code{list}() of connections use as target_conn.}

\item{data_files}{(\code{character()})\cr
List of files that should be available when testing.}

\item{target_schema}{(\code{character(1)})\cr
The data base schema where the tests should be run.}

\item{test_start_date}{(\code{Date})\cr
The earliest date to retrieve data from during tests.}

\item{...}{Other parameters passed to the diseasystore generator.}
}
\value{
NULL (called for side effects)
}
\description{
This function runs a battery of tests of the given diseasystore.

The supplied diseasystore must be a generator for the diseasystore, not an instance of the diseasystore.

The tests assume that data has been made available locally to run the majority of the tests.
The location of the local data should be configured in the options for "source_conn" of the given
diseasystore before calling test_diseasystore.
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
  withr::local_options("diseasystore.DiseasystoreEcdcRespiratoryViruses.pull" = FALSE)

  test_diseasystore(
    DiseasystoreEcdcRespiratoryViruses,
    \() list(DBI::dbConnect(RSQLite::SQLite())),
    data_files = "data/snapshots/2023-11-24_ILIARIRates.csv",
    target_schema = "test_ds",
    test_start_date = as.Date("2022-06-20"),
    slice_ts = "2023-11-24"
  )
}
\dontshow{\}) # examplesIf}
}
