% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mod_acp_utils.R
\name{plotly_pcabi}
\alias{plotly_pcabi}
\title{PCA biplot in 3D}
\usage{
plotly_pcabi(
  modelo,
  axes = c(1, 2, 3),
  colorInd = "steelblue",
  colorVar = "forestgreen",
  cos2Ind = 0,
  cos2Var = 0,
  colorIndCos = "firebrick",
  colorVarCos = "darkorchid",
  titulos = c("Bien Representados", "Mal Representados")
)
}
\arguments{
\item{modelo}{an object of class PCA [FactoMineR].}

\item{axes}{a numeric vector of length 3 specifying the dimensions to be plotted.}

\item{colorInd}{a color for the individuals well represented.}

\item{colorVar}{a color for the variables well represented.}

\item{cos2Ind}{a numeric value from 0 to 1 specifying the quality of the individuals.}

\item{cos2Var}{a numeric value from 0 to 1 specifying the quality of the variables.}

\item{colorIndCos}{a color for individuals badly represented.}

\item{colorVarCos}{a color for variables badly represented.}

\item{titulos}{a character vector of length 2 specifying the titles to use on legend.}
}
\value{
plotly plot
}
\description{
PCA biplot in 3D
}
\examples{
p <- discoveR:::PCA(iris[, -5], graph = FALSE)
plotly_pcabi(p)

}
\author{
Diego Jimenez <diego.jimenez@promidat.com>
}
