% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicPlot.R
\name{basicPlot}
\alias{basicPlot}
\title{Plot Graphs}
\usage{
basicPlot(
  ginp,
  graph_selection_input = 0,
  curvedEdgeLines = TRUE,
  arrowSizeMultiplier = 1,
  logScale = FALSE,
  logBase = NULL
)
}
\arguments{
\item{ginp}{The prepared graph object from prepareGraphs function}

\item{graph_selection_input}{The type of graphical projection to be used. Default projection is 0 (Fruchterman Reingold). Selection must be a numeric option from 0-2. Other options include:
1 = Kamada Kawai,
2 = Reingold Tilford}

\item{curvedEdgeLines}{Whether or not the edges between nodes should be curved or straight. Default is curved lines.}

\item{arrowSizeMultiplier}{Adjusts the default arrow size based on a multiplier. Default value is 1.}

\item{logScale}{Whether or not the edges of the graph should be scaled down based on a logarithmic scale}

\item{logBase}{If logScale = TRUE, then what logarithmic base should be applied to the graph's edges}
}
\value{
Returns graphical plot to disk, if selected, or to R console
}
\description{
Plots the graph using the base plot function. To map attributes on the graph use `plot1Att` for 1 attribute or `plot2Att` for 2 attributes.
}
\examples{

df <- sampleData1
prepNet <- tabulate_edges(df, iscsvfile = FALSE, silentNodes = 0)
baseNet <- prepareGraphs(prepNet, project_title = "Sample Data 1", weightedGraph = TRUE)

#Plot the graph
basicPlot(baseNet)


}
