% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posts.R
\name{posts}
\alias{posts}
\alias{post_get}
\alias{post_create}
\alias{post_wikify}
\title{Work with posts}
\usage{
post_get(post_id, url = NULL, key = NULL, user = NULL, ...)

post_create(topic_id, text, url = NULL, key = NULL, user = NULL, ...)

post_wikify(post_id, url = NULL, key = NULL, user = NULL, ...)
}
\arguments{
\item{post_id}{A post id}

\item{url}{Base url for a Discourse installation. See 
\code{\link{disc_setup}}}

\item{key}{Your api key on the Discourse installation. See 
\code{\link{disc_setup}}}

\item{user}{Your user name on the Discourse installation. See 
\code{\link{disc_setup}}}

\item{...}{Named parameters passed on to \code{\link[crul]{HttpClient}}}

\item{topic_id}{A topic id}

\item{text}{Text to put in post}
}
\description{
Work with posts
}
\examples{
\dontrun{
# get a post
post_get(90)
post_get(120)
post_get(130)
post_get(155)
cat(post_get(155)$raw)

# create post, create topic first
z <- topic_create("The problems with blue skies",
  text = "just saying these things cause I like the sky very much")
zz <- post_create(topic_id = z$topic_id,
  text = "There isn't a problem is there?")
topic(z$topic_id)
post_get(zz$id)

# Wikify a post
post_wikify(zz$id)

# cleanup - delete the topic
topic_delete(z$topic_id)
}
}
