% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfzipt.R
\name{dfzipt}
\alias{dfzipt}
\title{Discrete factor analysis with the truncated zero inflated Poisson distribution}
\usage{
dfzipt(y, A = NULL)
}
\arguments{
\item{y}{Data, an n by d numeric matrix}

\item{A}{truncation point (Note that if the data is in Likert scale
starting from 1, then you should subtract 1 from the data and then use the
proposed negative binomial models.}
}
\value{
A list with entries
\item{AIC}{AIC value for the optimal model}
\item{indexmat}{Factors and variables in each factor}
\item{estpilam}{Estimated zero-inflated parameters for  for each factor}
\item{estlam}{Estimated parameters for each factor}
\item{estpimu}{Estimated zero-inflated parameters for each variable within each factor}
\item{estmu}{Estimated parameters for each variable within each factor}
}
\description{
Discrete factor analysis with the truncated zero inflated Poisson distribution
}
\examples{
dfzipt(zinb100_Data[1:50,], A = 6)
}
