% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixdiag.R
\name{iact}
\alias{iact}
\title{Integrated Auto correlation times of a Markov Chain}
\usage{
iact(x)
}
\arguments{
\item{x}{chain (one dimension)}
}
\value{
Integrated ACT of the chain.
}
\description{
This function calculates the Integrated Auto Correlation Times of a Markov Chain.
}
\details{
The Integrated Auto Correlation Times of a Markov Chain X is defined as: \deqn{1 + 2 \sum \Gamma_i}, where \deqn{\Gamma} indicates the estimated autocorrelation terms of the chain. These are estimated using the sample correlation matrix from the lagged chain. This measure is intended for one dimensional chains or single component of a multivariate chains.
}
\examples{
\dontrun{
## Banana Target
lupost.banana <- function(x,B){
 -x[1]^2/200 - 1/2*(x[2]+B*x[1]^2-100*B)^2
}
Banana Gradient
gr.banana <- function(x,B){
 g1 <- -x[1]/100 - 2*B*(x[2]+B*x[1]^2-100*B)
 g2 <- -(x[2]+B*x[1]^2-100*B)
 g <- c(g1,g2)
 return(g)
} 
out.metdir.banana <- metropdir(obj = lupost.banana, dobj = gr.banana,
initial = c(0,1),lchain = 2000,
sd.prop=1.25,
steplen=0.01,s=1.5,B=0.03)
iact(out.metdir.banana$batch[,1])
}
}
\author{
Abhirup Mallik, \email{malli066@umn.edu}
}
\seealso{
\code{\link{msjd}} for mean squared jumping distance, \code{\link{mcmcdiag}}
for summary of diagnostic measures of a chain, \code{\link{multiESS}} for Multivariate effective sample size.
}
\keyword{dmh.}
\keyword{iact,}
\keyword{mcmc,}

