% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate3d.R
\name{rotate3d}
\alias{rotate3d}
\title{Spherical Coordinates Rotation}
\usage{
rotate3d(T, contrast)
}
\arguments{
\item{T}{a numeric matrix (normally z-score converted) with 3 columns. The rows are genes or phosphorylation
sites and the columns are treatments vs control statistics.}

\item{contrast}{the direction to be tested for enrichment. Specified as contrast in a triplet (see example).}
}
\value{
A rotated matrix with respect to the direction of interest.
}
\description{
Rotate to the direction of interest in spherical coordinates by contrasts (e.g. 1, -1, -1).
}
\examples{
# load the example data
data(PM)

# convert statistics into z-scores
PM.zscores <- apply(PM, 2, function(x){qnorm(rank(x)/(nrow(PM)+1))})

# Rotate the matrix by contrast 1, -1, -1 (i.e. up-regulation, down-regulation, dow-regulation).
PM.rotated <- rotate3d(PM.zscores, contrast = c(1, -1, -1))

}
