% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-inputbindings.R
\name{getInputBinding}
\alias{getInputBinding}
\title{Obtain registered input bindings}
\usage{
getInputBinding(fname, pkg = NULL, envir = parent.frame())
}
\arguments{
\item{fname}{input function name, character or quoted expression
such as \code{'shiny::textInput'} or \code{numericInput}.}

\item{pkg}{(optional), name of package}

\item{envir}{environment to evaluate \code{fname} if \code{pkg} is not provided}
}
\value{
a list containing: 1. `JavaScript` input binding name; 2. `R` updating function name
}
\description{
Obtain registered input bindings
}
\examples{

library(dipsaus)

# Most recommended usage
getInputBinding('compoundInput2', pkg = 'dipsaus')

# Other usages
getInputBinding('shiny::textInput')


getInputBinding(shiny::textInput)

getInputBinding(compoundInput2, pkg = 'dipsaus')

# Bad usage, raise errors in some cases
\dontrun{
## You need to library(shiny), or set envir=asNamespace('shiny'), or pkg='shiny'
getInputBinding('textInput')
getInputBinding(textInput) # also fails

## Always fails
getInputBinding('dipsaus::compoundInput2', pkg = 'dipsaus')
}

}
