% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallels-workers.R
\name{make_async_evaluator}
\alias{make_async_evaluator}
\title{Create Asynchronous Evaluator to Queue Tasks}
\usage{
make_async_evaluator(
  name,
  path = tempfile(),
  n_nodes = 1,
  n_subnodes = future::availableCores() - 1,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{name}{unique name for the evaluator}

\item{path}{blank directory for evaluator to store data}

\item{n_nodes}{number of control nodes, default is 1}

\item{n_subnodes}{number of sub-sessions for each control node, default is
the number of CPU cores minus 1}

\item{verbose}{for internal debug use}

\item{...}{passed to the constructor of \code{\link[dipsaus]{MasterEvaluator}}}
}
\description{
Asynchronous evaluator aims at queuing R evaluations from sub-processes
without blocking the main session. It's based on \code{'parallel'} and
\code{'future'} packages.
}
\details{
\code{'parallel'} blocks the main session when evaluating expressions.
\code{'future'} blocks the main session when the number of running futures
exceed the maximum number of workers. (For example if 4 workers are planned,
then running 5 future instances at the same time will freeze the session).

Asynchronous evaluator is designed to queue any number of R expressions
without blocking the main session. The incoming expressions are stored in
\code{\link[dipsaus]{AbstractQueue}} instances, and main session monitors
the queue and is charge of notifying child sessions to evaluate these
expressions whenever available.

Important: Asynchronous evaluator is not designed for super high-performance
computing. The internal scheduler schedules \code{n_nodes} evaluations for
every 1 second. Therefore if each of the process can be finished within
\code{1 / n_nodes} seconds, then use `future` instead.
}
\section{Value}{


A list of functions to control the evaluator:

\describe{

\item{\code{run(expr, success = NULL, failure = NULL, priority = 0,
persist = FALSE, quoted = FALSE, ..., .list = NULL)}}{
Queue and run an R expression.

\describe{

\item{\code{expr}}{
 can be anything except for
\code{q()}, which terminates the session. \code{'rlang'}
\code{\link[rlang]{nse-force}} is also supported. For example, you
can use \code{`!!`} to quasi-quote the expression and unquote the values.
}

\item{\code{..., .list}}{
provides additional data for \code{expr}. For example,
\code{expr} uses a large data object \code{dat} in the main session, which
might not be available to the child sessions. Also because the object
is large, quasi-quotation could be slow or fail. By passing \code{dat=...}
or \code{.list=list(dat=...)}, it's able to temporary store the data on
hard-drive and persist for evaluators. The back-end is using
\code{\link{qs_map}}, which is super fast for data that are no
more than \code{2GB}.
}

\item{\code{success} and \code{failure}}{
functions to handle the results once
the evaluator returns the value. Since it's almost impossible to know
when the evaluator returns values, it's recommended that these functions
to be simple.
}

\item{\code{priority}}{
puts the priority of the expression. It can only be `0` or
`1`. Evaluators will run expressions with priority equal to 1 first.
}

\item{\code{persist}}{
indicates whether to run the expression and persist
intermediate variables.
}
}
}

\item{\code{terminate()}}{
Shut down and release all the resource.
}

\item{\code{scale_down(n_nodes, n_subnodes = 1)},
      \code{scale_up(n_nodes, n_subnodes = 1,
      create_if_missing = FALSE, path = tempfile())}}{
Scale down or up the evaluator.
\describe{
\item{\code{n_nodes} and \code{n_subnodes}}{ see 'usage' }
\item{\code{create_if_missing}}{
If the evaluator was previously terminated or shutdown, setting this to be
true ignores the `invalid` flags and re-initialize the evaluator
}
\item{\code{path}}{
If \code{create_if_missing} is true, then \code{path} will be passed to
the constructor of \code{\link[dipsaus]{MasterEvaluator}}. See 'usage'.
}
}
}


\item{\code{workers(...)}}{
Returns number of workers available in the evaluator. \code{`...`} is for
debug use
}

\item{\code{progress()}}{
Returns a vector of 4 integers. They are:
\enumerate{
\item{ The total number evaluations. }
\item{ Number of running evaluations. }
\item{ Number of awaiting evaluations. }
\item{ Number of finished evaluations. }
}
}

}
}

