% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotdpp.R
\name{plotdpp}
\alias{plotdpp}
\title{Plots diagnostics from DiProPerm test}
\usage{
plotdpp(dpp, plots = "all", w = 0.001, h = 0.001)
}
\arguments{
\item{dpp}{A DiProPerm object.}

\item{plots}{A string designating the desired plots to be displayed:
"obs" displays the projection scores for the observed data,
"min" displays the projection scores for the permutation with the smallest univariate statistic value,
"max" displays the projection scores for the permutation with the largest univariate statistic value,
"permdist" displays the permutation distribution for \code{B} univariate statistics, and
"all" displays all 4 diagnostic plots in one plot.
Additionally, one can specify "perm1" to display the projection scores for the first permutation and "perm2" to display the projection scores for the second permutation.}

\item{w}{An integer indicating the width of the jitter. The default is 0.001.}

\item{h}{An integer indicating the height of the jitter.  The default is 0.001.}
}
\value{
A ggplot
}
\description{
This function plots the diagnostics of a DiProPerm test including the projection scores for the observed data, projection scores for the permutations with the smallest and largest univariate statistic values, and permutation distribution for \code{B} univariate statistics.
}
\examples{
\donttest{data(mushrooms)
X <- Matrix::t(mushrooms$X)
y <- mushrooms$y
dpp <- DiProPerm(X=X,y=y,B=10)
plotdpp(dpp)}
\dontshow{data(mushrooms)
X.temp <- SparseM::as.matrix(mushrooms$X)[,1:50]
X <- Matrix::t(X.temp)
y <- mushrooms$y[1:50]
dpp <- DiProPerm(X=X,y=y,B=100,classifier="md")
plotdpp(dpp)}
\dontshow{data(mushrooms)
X <- Matrix::t(mushrooms$X)
X <- X[1:50,]
y <- mushrooms$y[1:50]
dpp <- DiProPerm(X=X,y=y,B=100,classifier="svm")
plotdpp(dpp)}
}
\author{
Andrew G. Allmon, J.S. Marron, Michael G. Hudgens
}
