% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arithmetic.R
\name{date_xx_arithmetic}
\alias{date_xx_arithmetic}
\alias{+.date_xx}
\alias{-.date_xx}
\title{date_xx Arithmetic Operations}
\usage{
\method{+}{date_xx}(x, y)

\method{-}{date_xx}(x, y)
}
\arguments{
\item{x}{a \code{\link{date_yq}} or \code{\link{date_ym}} object}

\item{y}{an integer}

\item{...}{currently ignored}
}
\description{
The arithmetic operations \code{+}, \code{-} as well as sequence generation with
\code{seq()} are all supported for \code{date_yq} and \code{date_ym} objects. Other binary
arithmetic operators are disabled (see \link{date_xx_arithmetic_disabled}).
}
\examples{
q <- date_yq(2018, 1)


q + 5
q - 1
seq(q, q + 5)


m <- date_ym(2018, 12)
m + 1
m - 13
seq(m - 1, m + 1)
}
\seealso{
\link[base:Arithmetic]{base::Arithmetic}
}
