% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{DINA_Gibbs}
\alias{DINA_Gibbs}
\title{Generate Posterior Distribution with Gibbs sampler}
\usage{
DINA_Gibbs(Y,Amat,Q,chain_length)
}
\arguments{
\item{Y}{A N by J \code{matrix} of observed responses.}

\item{Amat}{A C by K \code{matrix} of possible attribute profiles.}

\item{Q}{A N by K \code{matrix} indicating which skills are required for which items.}

\item{chain_length}{Number of MCMC iterations.}
}
\value{
A list with samples from the posterior distribution.
}
\description{
Function for sampling parameters from full conditional distributions. The function returns a list of arrays or matrices with parameter posterior samples. Note that the output includes the posterior samples in objects named: \code{CLASSES} = individual attribute profiles, \code{PIs} = latent class proportions, \code{SS} = item slipping parameters, and \code{GS} = item guessing parameters.
}
\author{
Steven Andrew Culpepper
}
\seealso{
\code{\link{DINAsim}} 
}
\examples{
\dontrun{

###################################
#Tatsuoka Fraction Subtraction Data
###################################
require(CDM)
data(fraction.subtraction.data)
Y_1984 = as.matrix(fraction.subtraction.data)
Q_1984 = as.matrix(fraction.subtraction.qmatrix)
K_1984 = ncol(fraction.subtraction.qmatrix)
J_1984 = ncol(Y_1984)

#Creating matrix of possible attribute profiles
As_1984 = rep(0,K_1984)
for(j in 1:K_1984){
  temp = combn(1:K_1984,m=j)
  tempmat = matrix(0,ncol(temp),K_1984)
  for(j in 1:ncol(temp)) tempmat[j,temp[,j]] = 1
  As_1984 = rbind(As_1984,tempmat)
}
As_1984 = as.matrix(As_1984)

#Generate samples from posterior distribution
  #May take 8 minutes
chainLength = 5000
burnin = 1000
outchain_1984 <- DINA_Gibbs(Y=Y_1984,Amat=As_1984,Q_1984,chain_length=chainLength)

  #Summarize posterior samples for g and 1-s
  mgs_1984 = apply(outchain_1984$GS[,burnin:chainLength],1,mean)
  sgs_1984 = apply(outchain_1984$GS[,burnin:chainLength],1,sd)
  mss_1984 = 1-apply(outchain_1984$SS[,burnin:chainLength],1,mean)
  sss_1984 = apply(outchain_1984$SS[,burnin:chainLength],1,sd)
  output_1984=cbind(mgs_1984,sgs_1984,mss_1984,sss_1984)
  colnames(output_1984) = c('g Est','g SE','1-s Est','1-s SE')
  rownames(output_1984) = colnames(Y_1984)
  print(output_1984,digits=3)

  #Summarize marginal skill distribution using posterior samples for latent class proportions
  marg_PIs = t(As_1984)\%*\%outchain_1984$PIs
  PI_Est = apply(marg_PIs[,burnin:chainLength],1,mean)
  PI_Sd = apply(marg_PIs[,burnin:chainLength],1,sd)
  PIoutput = cbind(PI_Est,PI_Sd)
  colnames(PIoutput) = c('EST','SE')
  rownames(PIoutput) = paste0('Skill ',1:K_1984)
  print(PIoutput,digits=3)
    }
#####################################################
#de la Torre (2009) Simulation Replication w/ N = 200
#####################################################
N = 200
K = 5
J=30
delta0 = rep(1,2^K)

#Creating Q matrix
Q = matrix(rep(diag(K),2),2*K,K,byrow=TRUE)
for(mm in 2:K){
  temp = combn(1:K,m=mm)
  tempmat = matrix(0,ncol(temp),K)
  for(j in 1:ncol(temp)) tempmat[j,temp[,j]] = 1
  Q = rbind(Q,tempmat)
}
Q = Q[1:J,]

#Setting item parameters and generating attribute profiles
ss = gs = rep(.2,J)
PIs = rep(1/(2^K),2^K)
CLs = c((1:(2^K))\%*\%rmultinom(n=N,size=1,prob=PIs) )

#Defining matrix of possible attribute profiles
As = rep(0,K)
for(j in 1:K){
  temp = combn(1:K,m=j)
  tempmat = matrix(0,ncol(temp),K)
  for(j in 1:ncol(temp)) tempmat[j,temp[,j]] = 1
  As = rbind(As,tempmat)
}
As = as.matrix(As)

#Sample true attribute profiles
Alphas = As[CLs,]

#Simulate data under DINA model 
gen = DINAsim(Alphas,Q,ss,gs)
Y_sim = gen$Y

#Execute MCMC
#NoTE small chain length used to reduce computation time for pedagogical example.
chainLength = 200
burnin = 100

  outchain <- DINA_Gibbs(Y_sim,Amat=As,Q,chain_length=chainLength)

  #Summarize posterior samples for g and 1-s  
  mGs = apply(outchain$GS[,burnin:chainLength],1,mean)
  sGs = apply(outchain$GS[,burnin:chainLength],1,sd)
  m1mSS = 1-apply(outchain$SS[,burnin:chainLength],1,mean)
  s1mSS = apply(outchain$SS[,burnin:chainLength],1,sd)
  output=cbind(mGs,sGs,m1mSS,s1mSS)
  colnames(output) = c('g Est','g SE','1-s Est','1-s SE')
  rownames(output) = paste0('Item ',1:J)
  print(output,digits=3)

  #Summarize marginal skill distribution using posterior samples for latent class proportions
  PIoutput = cbind(apply(outchain$PIs,1,mean),apply(outchain$PIs,1,sd))
  colnames(PIoutput) = c('EST','SE')
  rownames(PIoutput) = apply(As,1,paste0,collapse='')
  print(PIoutput,digits=3)
}
