% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/get_coordinates.R
\docType{methods}
\name{get_coordinates}
\alias{get_coordinates}
\alias{get_coordinates-method}
\alias{get_replications}
\alias{get_replications-method}
\alias{get_coordinates,MultivariateAnalysis-method}
\alias{get_coordinates,PCOA-method}
\alias{get_replications,MultivariateBootstrap-method}
\alias{get_replications,BootstrapPCA-method}
\title{Get Coordinates}
\usage{
get_coordinates(x, ...)

get_replications(x, ...)

\S4method{get_coordinates}{MultivariateAnalysis}(x, margin = 1, principal = TRUE, sup_name = ".sup")

\S4method{get_coordinates}{PCOA}(x)

\S4method{get_replications}{MultivariateBootstrap}(x, margin = 1)

\S4method{get_replications}{BootstrapPCA}(x)
}
\arguments{
\item{x}{An object from which to get element(s) (a \code{\linkS4class{CA}},
\code{\linkS4class{MCA}} or \code{\linkS4class{PCA}} object).}

\item{...}{Currently not used.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscript which the
data will be returned: \code{1} indicates individuals/rows (the default), \code{2}
indicates variables/columns.}

\item{principal}{A \code{\link{logical}} scalar: should principal coordinates be
returned? If \code{FALSE}, standard coordinates are returned.}

\item{sup_name}{A \code{\link{character}} string specifying the name of the column to
create for supplementary points attribution (see below).}
}
\value{
\itemize{
\item \code{get_coordinates()} returns a \code{\link{data.frame}} of coordinates. An extra
column (named after \code{sup_name}) is added specifying whether an observation
is a supplementary point or not.
\item \code{get_replications()} returns an \code{\link{array}} of coordinates.
}
}
\description{
Get Coordinates
}
\examples{
## Load data
data("iris")

## Compute principal components analysis
X <- pca(iris, scale = TRUE, sup_row = 5:10)

## Get row principal coordinates
head(get_coordinates(X, margin = 1, principal = TRUE))

## Get row standard coordinates
head(get_coordinates(X, margin = 1, principal = FALSE))

## Tidy principal coordinates
head(tidy(X, margin = 1))
head(tidy(X, margin = 2))

head(augment(X, margin = 1, axes = c(1, 2)))
head(augment(X, margin = 2, axes = c(1, 2)))
}
\seealso{
Other getters: 
\code{\link{export}()},
\code{\link{get_contributions}()},
\code{\link{get_data}()},
\code{\link{get_eigenvalues}()}
}
\author{
N. Frerebeau
}
\concept{getters}
