% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/pcoa.R
\docType{methods}
\name{pcoa}
\alias{pcoa}
\alias{pcoa-method}
\alias{pcoa,dist-method}
\title{Principal Coordinates Analysis}
\usage{
pcoa(object, ...)

\S4method{pcoa}{dist}(object, rank = 2)
}
\arguments{
\item{object}{A \link[stats:dist]{distance structure}.}

\item{...}{Currently not used.}

\item{rank}{An \code{\link{integer}} value specifying the maximal number dimension of
the space which the data are to be represented in.}
}
\value{
A \code{\linkS4class{PCOA}} object.
}
\description{
Computes classical (metric) multidimensional scaling.
}
\examples{
## Load data
data("iris")

## Compute euclidean distances
d <- dist(iris[, 1:4], method = "euclidean")

## Compute principal coordinates analysis
X <- pcoa(d)

## Screeplot
screeplot(X)

## Plot results
plot(X, extra_quali = iris$Species)
}
\references{
Gower, J. C. (1966). Some Distance Properties of Latent Root and Vector
Methods Used in Multivariate Analysis. \emph{Biometrika}, 53(3‑4): 325-338.
\doi{10.1093/biomet/53.3-4.325}.
}
\seealso{
\code{\link[stats:cmdscale]{stats::cmdscale()}}

Other multivariate analysis: 
\code{\link{ca}()},
\code{\link{mca}()},
\code{\link{pca}()},
\code{\link{predict}()}
}
\author{
N. Frerebeau
}
\concept{multivariate analysis}
