% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalMetrics.R
\name{barErrorPlot}
\alias{barErrorPlot}
\title{Generate bar error plots}
\usage{
barErrorPlot(
  object,
  error = "MSE",
  by = "CellType",
  dispersion = "se",
  filter.sc = TRUE,
  title = NULL,
  angle = NULL,
  theme = NULL
)
}
\arguments{
\item{object}{\code{DigitalDLSorter} object with \code{trained.model} slot
containing metrics in \code{test.deconv.metrics} slot.}

\item{error}{\code{'MAE'} or \code{'MSE'}.}

\item{by}{Variable used to display errors. Available options are:
\code{'nCellTypes'}, \code{'CellType'}.}

\item{dispersion}{Standard error (\code{'se'}) or standard deviation
(\code{'sd'}). The former is the default.}

\item{filter.sc}{Boolean indicating whether single-cell profiles are filtered
out and only correlation of results associated with bulk samples are
displayed (\code{TRUE} by default).}

\item{title}{Title of the plot.}

\item{angle}{Angle of ticks.}

\item{theme}{\pkg{ggplot2} theme.}
}
\value{
A ggplot object with the mean and dispersion of the errors
}
\description{
Generate bar error plots by cell type (\code{CellType}) or by number of
different cell types (\code{nCellTypes}) on test pseudo-bulk samples.
}
\examples{
\dontrun{
set.seed(123)
sce <- SingleCellExperiment::SingleCellExperiment(
  assays = list(
    counts = matrix(
      rpois(30, lambda = 5), nrow = 15, ncol = 20,
      dimnames = list(paste0("Gene", seq(15)), paste0("RHC", seq(20)))
    )
  ),
  colData = data.frame(
    Cell_ID = paste0("RHC", seq(20)),
    Cell_Type = sample(x = paste0("CellType", seq(6)), size = 20,
                       replace = TRUE)
  ),
  rowData = data.frame(
    Gene_ID = paste0("Gene", seq(15))
  )
)
DDLS <- createDDLSobject(
  sc.data = sce,
  sc.cell.ID.column = "Cell_ID",
  sc.gene.ID.column = "Gene_ID",
  sc.filt.genes.cluster = FALSE, 
  sc.log.FC = FALSE
)
probMatrixValid <- data.frame(
  Cell_Type = paste0("CellType", seq(6)),
  from = c(1, 1, 1, 15, 15, 30),
  to = c(15, 15, 30, 50, 50, 70)
)
DDLS <- generateBulkCellMatrix(
  object = DDLS,
  cell.ID.column = "Cell_ID",
  cell.type.column = "Cell_Type",
  prob.design = probMatrixValid,
  num.bulk.samples = 50,
  verbose = TRUE
)
# training of DDLS model
tensorflow::tf$compat$v1$disable_eager_execution()
DDLS <- trainDDLSModel(
  object = DDLS,
  on.the.fly = TRUE,
  batch.size = 15,
  num.epochs = 5
)
# evaluation using test data
DDLS <- calculateEvalMetrics(
  object = DDLS
)
# bar error plots
barErrorPlot(
  object = DDLS,
  error = "MSE",
  by = "CellType"
)
barErrorPlot(
  object = DDLS,
  error = "MAE",
  by = "nCellTypes"
)
}

}
\seealso{
\code{\link{calculateEvalMetrics}} \code{\link{corrExpPredPlot}}
\code{\link{distErrorPlot}} \code{\link{blandAltmanLehPlot}}
}
