% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrw.R
\docType{methods}
\name{random.walk}
\alias{random.walk}
\alias{random.walk,numeric,matrix-method}
\alias{random.walk,matrix,matrix-method}
\title{Graph diffusion using a Markov random walk}
\usage{
random.walk(p0, graph, r = 0.5, niter = 10000, thresh = 1e-04,
  do.analytical = FALSE, ...)

\S4method{random.walk}{numeric,matrix}(p0, graph, r = 0.5, niter = 10000,
  thresh = 1e-04, do.analytical = FALSE, ...)

\S4method{random.walk}{matrix,matrix}(p0, graph, r = 0.5, niter = 10000,
  thresh = 1e-04, do.analytical = FALSE, ...)
}
\arguments{
\item{p0}{an \code{n x p}-dimensional numeric non-negative vector/matrix
representing the starting distribution of the Markov chain
(does not need to sum to one).}

\item{graph}{an (\code{n x n})-dimensional numeric non-negative adjacence
matrix representing the graph}

\item{r}{a scalar between (0, 1). restart probability if a Markov random
walk with restart is desired}

\item{niter}{maximal number of iterations for computation of the
 Markov chain. If \code{thresh} is not reached, then \code{niter} is used as
stop criterion.}

\item{thresh}{threshold for breaking the iterative computation of the
stationary distribution. If the absolute difference of the distribution at
time point $t-1$ and $t$ is less than \code{thresh}, then the algorithm stops.
If \code{thresh} is not reached before \code{niter}, then the algorithm stops
as well.}

\item{do.analytical}{boolean if the stationary distribution shall be
computed solving the analytical solution or rather iteratively}

\item{...}{additional parameters}
}
\value{
returns the stationary distribution as numeric vector
}
\description{
A Markov Random Walk takes an inital distribution \code{p0}
and calculates the stationary distribution of that.
The diffusion process is regulated by a restart probability \code{r} which
controls how often the MRW jumps back to the initial values.
}
\examples{
# count of nodes
n <- 5
# starting distribution (has to sum to one)
p0    <- as.vector(rmultinom(1, 1, prob=rep(.2, n)))
# adjacency matrix (either normalized or not)
graph <- matrix(abs(rnorm(n*n)), n, n)
# computation of stationary distribution
pt    <- random.walk(p0, graph)
}
\references{
Tong, H., Faloutsos, C., & Pan, J. Y. (2006),
Fast random walk with restart and its applications.\cr \cr
Koehler, S., Bauer, S., Horn, D., & Robinson, P. N. (2008),
Walking the interactome for prioritization of candidate disease genes.
\emph{The American Journal of Human Genetics}\cr \cr
}
