% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\docType{methods}
\name{trim}
\alias{trim}
\alias{trimChr}
\alias{trimChr,}
\alias{trimChr,ANY,character-method}
\alias{trimDeparse}
\alias{trimDeparse,}
\alias{trimDeparse,ANY,character-method}
\alias{trimFile}
\alias{trimFile,ANY,character-method}
\alias{trimPrint}
\alias{trimPrint,}
\alias{trimPrint,ANY,character-method}
\alias{trimStr}
\alias{trimStr,}
\alias{trimStr,ANY,character-method}
\title{Methods to Remove Unsemantic Text Prior to Diff}
\usage{
trimPrint(obj, obj.as.chr)

\S4method{trimPrint}{ANY,character}(obj, obj.as.chr)

trimStr(obj, obj.as.chr)

\S4method{trimStr}{ANY,character}(obj, obj.as.chr)

trimChr(obj, obj.as.chr)

\S4method{trimChr}{ANY,character}(obj, obj.as.chr)

trimDeparse(obj, obj.as.chr)

\S4method{trimDeparse}{ANY,character}(obj, obj.as.chr)

trimFile(obj, obj.as.chr)

\S4method{trimFile}{ANY,character}(obj, obj.as.chr)
}
\arguments{
\item{obj}{the object}

\item{obj.as.chr}{character the \code{print}ed representation of the object}
}
\value{
a \code{length(obj.as.chr)} row and 2 column integer matrix with the
  start (first column) and end (second column) character positions of the sub
  string to run diffs on.
}
\description{
\code{diff*} methods, in particular \code{diffPrint}, modify the text
representation of an object prior to running the diff to reduce the incidence
of spurious mismatches caused by unsemantic differences.  For example, we
look to remove matrix row indices and atomic vector indices (i.e. the
\samp{[1]} or \samp{[1,]} strings at the beginning of each display line).
}
\details{
Consider: \preformatted{
> matrix(10:12)
     [,1]
[1,]   10
[2,]   11
[3,]   12
> matrix(11:12)
     [,1]
[1,]   11
[2,]   12
}
In this case, the line by line diff would find all rows of the matrix to
be mismatched because where the data matches (rows containing
11 and 12) the indices do not.  By trimming out the row indices before
the diff, the diff can recognize that row 2 and 3  from the first matrix
should be matched to row 1 and 2 of the second.

These methods follow a similar interface as the \code{\link[=guides]{guide*}}
methods, with one available for each \code{diff*} method except for
\code{diffCsv} since that one uses \code{diffPrint} internally.  The
unsemantic differences are added back after the diff for display purposes,
and are colored in grey to indicate they are ignored in the diff.

Currently only \code{trimPrint} and \code{trimStr} do anything meaningful.
\code{trimPrint} removes row index headers provided that they are of the
default un-named variety.  If you add row names, or if numeric row indices
are not ascending from 1, they will not be stripped as those have meaning.
\code{trimStr} removes the \samp{..$} and \samp{..-} tokens
to minimize spurious matches.

You can modify how text is trimmed by providing your own functions to the
\code{trim} argument of the \code{diff*} methods, or by defining
\code{trim*} methods for your objects.  Note that the return value for these
functions is the start and end columns of the text that should be
\emph{kept} and used in the diff.
}
\note{
\code{obj.as.chr} will be post \code{strip_hz_control}
}

