% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimNLR.R
\name{estimNLR}
\alias{estimNLR}
\title{Non-Linear Regression DIF models estimation.}
\usage{
estimNLR(y, match, group, formula, method, lower, upper, start)
}
\arguments{
\item{y}{numeric: binary vector of responses.}

\item{match}{numeric: vector of matching criterion.}

\item{group}{numeric: binary vector of group membership. \code{"0"} for reference group, \code{"1"} for focal group.}

\item{formula}{formula: specification of the model. Can be obtained by \code{formulaNLR()} function.}

\item{method}{character: method used to estimate parameters. The options are \code{"nls"} for non-linear least
squares (default), \code{"likelihood"} for maximum likelihood method, and \code{"irls"} for maximum likelihood
estimation with iteratively reweighted least squares. See \strong{Details}.}

\item{lower}{numeric: lower bounds for parameters of model specified in \code{formula}.}

\item{upper}{numeric: upper bounds for parameters of model specified in \code{formula}.}

\item{start}{numeric: initial parameters. Can be obtained by \code{startNLR()} function.}
}
\description{
Estimates parameters of non-linear regression models for DIF detection using either
non-linear least squares or maximum likelihood method.
}
\details{
Function offers either non-linear least squares estimation via \code{\link[stats]{nls}} function,
maximum likelihood method with \code{"L-BFGS-B"} method via \code{\link[stats]{optim}} function,
or maximum likelihood method with iteratively reweighted least squares via \code{\link[stats]{glm}}
function.
}
\examples{
# loading data
data(GMAT)
y <- GMAT[, 1] # item 1
match <- scale(rowSums(GMAT[, 1:20])) # standardized total score
group <- GMAT[, "group"] # group membership variable

# formula for 3PL model with the same guessing
M <- formulaNLR(model = "3PLcg", type = "both")

# starting values for 3PL model with the same guessing for item 1
start <- startNLR(GMAT[, 1:20], group, model = "3PLcg", parameterization = "classic")
start <- start[[1]][M$M0$parameters]

# non-linear least squares
fitNLSM0 <- estimNLR(
  y = y, match = match, group = group,
  formula = M$M0$formula, method = "nls",
  lower = M$M0$lower, upper = M$M0$upper, start = start
)
fitNLSM0

coef(fitNLSM0)
logLik(fitNLSM0)
vcov(fitNLSM0)
vcov(fitNLSM0, sandwich = TRUE)
fitted(fitNLSM0)
residuals(fitNLSM0)

# maximum likelihood method
fitLKLM0 <- estimNLR(
  y = y, match = match, group = group,
  formula = M$M0$formula, method = "likelihood",
  lower = M$M0$lower, upper = M$M0$upper, start = start
)
fitLKLM0

coef(fitLKLM0)
logLik(fitLKLM0)
vcov(fitLKLM0)
fitted(fitLKLM0)
residuals(fitLKLM0)

# iteratively reweighted least squares for 2PL model
M <- formulaNLR(model = "2PL", parameterization = "logistic")
fitIRLSM1 <- estimNLR(
  y = y, match = match, group = group,
  formula = M$M1$formula, method = "irls"
)
fitIRLSM1

coef(fitIRLSM1)
logLik(fitIRLSM1)
vcov(fitIRLSM1)
fitted(fitIRLSM1)
residuals(fitIRLSM1)
}
\references{
Hladka, A. (2021). Statistical models for detection of differential item functioning. Dissertation thesis.
Faculty of Mathematics and Physics, Charles University.
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
\keyword{DIF}
