% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em.R
\name{e_step_mn}
\alias{e_step_mn}
\title{Computed expected log likelihood of multinomial mixture}
\usage{
e_step_mn(x, p, mc, Llks = NULL, labels = NULL)
}
\arguments{
\item{x}{sparseMatrix. A sample by feature matrix of counts.}

\item{p}{numeric matrix. A feature by group matrix of probabilities.}

\item{mc}{numeric. Mixture coefficients}

\item{Llks}{If log likelihood was computed for the mixture, provide the 
matrix here.}

\item{labels}{Numeric vector of same length as number of rows in x. Fixes 
the group probabilities of the integer in this vector element to 1. In 
other words, the latent variable for these samples are treated as known.}
}
\value{
a numeric matrix with n samples by k groups.
}
\description{
Given an n x p matrix of count data \code{x}, as well as a 
p x k matrix of probabilities \code{p}, return the responsibilities 
of each sample for the k groups in a n x k matrix. If \code{x} 
has any non-integer values, they are rounded to the nearest integer.
}
