% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diceplot.R
\name{dice_plot}
\alias{dice_plot}
\title{Dice Plot Visualization}
\usage{
dice_plot(
  data,
  cat_a,
  cat_b,
  cat_c,
  group = NULL,
  group_alpha = 0.5,
  title = NULL,
  cat_c_colors = NULL,
  group_colors = NULL,
  custom_theme = theme_minimal(),
  max_dot_size = 5,
  min_dot_size = 2,
  legend_width = 0.25,
  legend_height = 0.5,
  base_width_per_cat_a = 0.5,
  base_height_per_cat_b = 0.3,
  reverse_ordering = FALSE,
  cat_b_order = NULL
)
}
\arguments{
\item{data}{A data frame containing the categorical and group variables for plotting.}

\item{cat_a}{A string representing the column name in \code{data} for the first categorical variable.}

\item{cat_b}{A string representing the column name in \code{data} for the second categorical variable.}

\item{cat_c}{A string representing the column name in \code{data} for the third categorical variable.}

\item{group}{A string representing the column name in \code{data} for the grouping variable.}

\item{group_alpha}{A numeric value for the transparency level of the group rectangles. Default is \code{0.5}.}

\item{title}{An optional string for the plot title. Defaults to \code{NULL}.}

\item{cat_c_colors}{A named vector of colors for \code{cat_c} categories or a string to chose a colorbrewer palette. Defaults to \code{NULL} using the first suitable colorbrewer palette to use.}

\item{group_colors}{A named vector of colors for the group variableor a string to chose a colorbrewer palette. Defaults to \code{NULL} using the first suitable colorbrewer palette to use.}

\item{custom_theme}{A ggplot2 theme for customizing the plot's appearance. Defaults to \code{theme_minimal()}.}

\item{max_dot_size}{Maximal dot size for the plot to scale the dot sizes.}

\item{min_dot_size}{Minimal dot size for the plot to scale the dot sizes.}

\item{legend_width}{Relative width of your legend. Default is 0.25.}

\item{legend_height}{Relative width of your legend. Default is 0.5.}

\item{base_width_per_cat_a}{Used for dynamically scaling the width. Default is 0.5.}

\item{base_height_per_cat_b}{Used for dynamically scaling the height. Default is 0.3.}

\item{reverse_ordering}{Should the cluster ordering be reversed?. Default is FALSE.}

\item{cat_b_order}{Do you want to pass an explicit order?. Default is NULL.}
}
\value{
A ggplot object representing the dice plot.
}
\description{
This function generates a custom plot based on three categorical variables and a group variable. It adapts to the number of unique categories in \code{cat_c} and allows customization of various plot aesthetics.
}
