% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_network.R
\name{dropout}
\alias{dropout}
\alias{epochs}
\alias{hidden_units}
\alias{batch_size}
\title{Neural network parameters}
\usage{
dropout(range = c(0, 1), trans = NULL)

epochs(range = c(10L, 1000L), trans = NULL)

hidden_units(range = c(1L, 10L), trans = NULL)

batch_size(range = c(unknown(), unknown()), trans = log2_trans())
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
These functions generate parameters that are useful for neural network models.
}
\details{
\itemize{
\item \code{dropout()}: The parameter dropout rate. (See \code{parsnip:::mlp()}).
\item \code{epochs()}: The number of iterations of training. (See \code{parsnip:::mlp()}).
\item \code{hidden_units()}: The number of hidden units in a network layer.
(See \code{parsnip:::mlp()}).
\item \code{batch_size()}: The mini-batch size for neural networks.
}
}
\examples{
dropout()
}
