% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_mtry.R
\name{mtry}
\alias{mtry}
\alias{mtry_long}
\title{Number of randomly sampled predictors}
\usage{
mtry(range = c(1L, unknown()), trans = NULL)

mtry_long(range = c(0L, unknown()), trans = log10_trans())
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
The number of predictors that will be randomly sampled at each split when
creating tree models.
}
\details{
This parameter is used for regularized or penalized models such as
\code{parsnip::rand_forest()} and others. \code{mtry_long()} has the values on the
log10 scale and is helpful when the data contain a large number of predictors.

Since the scale of the parameter depends on the number of columns in the
data set, the upper bound is set to \code{unknown} but can be filled in via the
\code{finalize()} method.
}
\examples{
mtry(c(1L, 10L))   # in original units
mtry_long(c(0, 5)) # in log10 units
}
