% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_engine_party.R
\docType{data}
\name{conditional_min_criterion}
\alias{conditional_min_criterion}
\alias{values_test_type}
\alias{conditional_test_type}
\alias{values_test_statistic}
\alias{conditional_test_statistic}
\title{Parameters for possible engine parameters for party models}
\format{
An object of class \code{character} of length 5.

An object of class \code{character} of length 2.
}
\usage{
conditional_min_criterion(
  range = c(1.386294, 15),
  trans = scales::logit_trans()
)

values_test_type

conditional_test_type(values = values_test_type)

values_test_statistic

conditional_test_statistic(values = values_test_statistic)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}

\item{values}{A character string of possible values.}
}
\value{
For the functions, they return a function with classes "param" and
either "quant_param" or "qual_param".
}
\description{
Parameters for possible engine parameters for party models
}
\details{
The range of \code{conditional_min_criterion()} corresponds to roughly 0.80 to
0.99997 in the natural units. For several test types, this parameter
corresponds to \code{1 - {p-value}}.
}
\keyword{datasets}
