% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagstats.R
\name{diagstats}
\alias{diagstats}
\title{Calculate statistical measures of test performance for objects of
class \code{diagmeta}}
\usage{
diagstats(x, cutoff = x$optcut, sens, spec, prevalence, level = 0.95)
}
\arguments{
\item{x}{An object of class \code{diagmeta}}

\item{cutoff}{A numeric or vector with cutoff value(s)}

\item{sens}{A numeric or vector with sensitivity value(s)}

\item{spec}{A numeric or vector with specificity value(s)}

\item{prevalence}{A numeric or vector with the prevalence(s)}

\item{level}{The level used to calculate confidence intervals}
}
\value{
A data frame of class "diagstats" with the following variables:
\item{cutoff}{Cutoffs provided in argument "cutoff" and / or
  model-based cutoff values for given sensitivities /
  specificities.}
\item{Sens}{Sensitivities provided in argument "sens" and / or
  model-based estimates of the sensitivity for given cutoffs /
  specificities}
\item{seSens}{Standard error of sensitivity}
\item{lower.Sens, upper.Sens}{Lower and upper confidence limits of
  the sensitivity}
\item{Spec}{Specificities provided in argument "spec" and / or
  model-based estimates of the specificity for given cutoffs /
  sensitivities}
\item{seSpec}{Standard error of specificity}
\item{lower.Spec, upper.Spec}{Lower and upper confidence limits of
  the specificity}
\item{prevalence}{As defined above.}
\item{PPV}{Positive predictive value (based on the cutoff)}
\item{NPV}{Negative predictive value (based on the cutoff)}
\item{PD}{Probability of disease if the given cutoff value was
  observed as the measurement for an individual}
\item{dens.nondiseased}{Value of the model-based density function at the
   cutoff(s) for non-diseased individuals}
\item{dens.diseased}{Value of the model-based density function at the
   cutoff(s) for diseased individuals}
}
\description{
The user can provide cutoffs, sensitivities, and / or specificities
to calculate the respective quantities (with confidence
intervals). Furthermore, positive predictive values (PPV), negative
predictive values (NPV), and probabilities of disease (PD) are
calculated if the prevalence is provided.
}
\examples{
# FENO dataset
#
data(Schneider2017)

diag1 <- diagmeta(tpos, fpos, tneg, fneg, cutpoint,
                  studlab = paste(author, year, group),
                  data = Schneider2017, 
                  model = "DIDS", log.cutoff = TRUE)

# Results at the optimal cutoff
#
diagstats(diag1)

# Results for cutoffs 25 and 50 (and a prevalence of 10\%)
#
diagstats(diag1, c(25, 50), prevalence = 0.10)

# Results for sensitivity and specificity of 0.95
#
diagstats(diag1, sens = 0.95, spec = 0.95)

}
\seealso{
\code{\link{diagmeta}} \code{\link{print.diagstats}}
}
\author{
Gerta Rücker \email{ruecker@imbi.uni-freiburg.de},
Srinath Kolampally \email{kolampal@imbi.uni-freiburg.de},
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
