% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CookDistance.R
\name{CookDistance}
\alias{CookDistance}
\title{Calculate Cook Distance}
\usage{
CookDistance(model)
}
\arguments{
\item{model}{Object returned from regL1 representing the fit of the L1 model.}
}
\value{
\item{Cook Distance}{          A vector with Cook Distance for each observation.}.
}
\description{
Calculate Cook Distance
}
\examples{
set.seed(123)
x = matrix(rnorm(100), ncol = 2)
y = x[, 1] + x[, 2] + rlaplace(50, 0, 5)

# Fits a linear regression L1 model
mod1 = regL1(y ~ x)
CookDistance(mod1)
}
\references{
Sun, R.-B. and Wei, B.-C. (2004). On influence assessment for lad regression.
\emph{Statistics & Probability Letters}, \strong{67}, 97-110. \doi{10.1016/j.spl.2003.08.018}.
}
