% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.VAR}
\alias{.VAR}
\title{(Fast) Barebones Vector-Autoregression}
\usage{
.VAR(x, p = 1L)
}
\arguments{
\item{x}{data numeric matrix with time series in columns - without missing values.}

\item{p}{positive integer. The lag order of the VAR.}
}
\value{
A list containing matrices \code{Y = x[-(1:p), ]}, \code{X} which contains lags 1 - p of \code{x} combined column-wise,
\code{A} which is the \eqn{np \times n}{np x n} transition matrix, where n is the number of series in \code{x}, and the VAR residual matrix \code{res = Y - X \%*\% A}.

A list with the following elements:
\item{\code{Y}}{\code{x[-(1:p), ]}. }
\item{\code{X}}{lags 1 - p of \code{x} combined column-wise. }
\item{\code{A}}{\eqn{np \times n}{np x n} transition matrix, where n is the number of series in \code{x}. }
\item{\code{res}}{VAR residual matrix: \code{Y - X \%*\% A}. }
}
\description{
Quickly estimate a VAR(p) model using Armadillo's inverse function.
}
\examples{
var = .VAR(diff(EuStockMarkets), 3)
str(var)
var$A
rm(var)

}
