% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfidx.R
\name{dfidx}
\alias{dfidx}
\title{Data frames with indexes}
\usage{
dfidx(
  data,
  idx = NULL,
  drop.index = TRUE,
  as.factor = NULL,
  pkg = NULL,
  fancy.row.names = FALSE,
  subset = NULL,
  idnames = NULL,
  shape = c("long", "wide"),
  choice = NULL,
  varying = NULL,
  sep = ".",
  opposite = NULL,
  levels = NULL,
  ranked = FALSE,
  ...
)
}
\arguments{
\item{data}{a data frame}

\item{idx}{an index}

\item{drop.index}{if \code{TRUE} (the default), remove the index series
from the data.frame as stand alone series}

\item{as.factor}{should the indexes be coerced to factors ?}

\item{pkg}{if set, the resulting \code{dfidx} object is of class
\code{c("dfidx_pkg", "dfidx")} which enables to write specific
classes}

\item{fancy.row.names}{if \code{TRUE}, fancy row names are computed}

\item{subset}{a logical which defines a subset of rows to return}

\item{idnames}{the names of the indexes}

\item{shape}{either \code{wide} or \code{long}}

\item{choice}{the choice}

\item{varying, sep}{relevant for data sets in wide format, these
arguments are passed to reshape}

\item{opposite}{return the opposite of the series}

\item{levels}{the levels for the second index}

\item{ranked}{a boolean for ranked data}

\item{...}{further arguments}
}
\value{
an object of class \code{"dfidx"}
}
\description{
data frames for which observations are defined by two (potentialy
nested) indexes and for which series have thefore a natural tabular
representation
}
\details{
Indexes are stored as a \code{data.frame} column in the
resulting \code{dfidx} object
}
\examples{
if (requireNamespace("AER")){
data("TravelMode", package = "AER")

# the first two columns contain the index

TM1 <- dfidx(TravelMode)

# explicitely indicate the two indexes using either a vector or a
# list of two characters

TM2 <- dfidx(TravelMode, idx = c("individual", "mode"))

TM3 <- dfidx(TravelMode, idx = list("individual", "mode"))

# rename one or both indexes

TM3b <- dfidx(TravelMode, idnames = c(NA, "trmode"))

# for balanced data (with observations ordered by the first, then
# by the second index

# use the name of the first index

TM4 <- dfidx(TravelMode, idx = "individual", idnames = c("individual", "mode"))

# or an integer equal to the cardinal of the first index

TM5 <- dfidx(TravelMode, idx = 210, idnames = c("individual", "mode"))

# Indicate the values of the second index using the levels argument

TM5b <- dfidx(TravelMode, idx = 210, idnames = c("individual", "mode"),
levels = c("air", "train", "bus", "car"))
}

# Nesting structure for one of the index
if (requireNamespace("mlogit")){
data("JapaneseFDI", package = "mlogit")
JapaneseFDI <- dplyr::select(JapaneseFDI, 1:8)
JP1b <- dfidx(JapaneseFDI, idx = list("firm", c("region", "country")),
idnames = c("japf", "iso80"))
}
# Data in wide format
if (requireNamespace("mlogit")){
data("Fishing", package = "mlogit")
Fi <- dfidx(Fishing, shape = "wide", varying = 2:9, idnames = c("chid", "alt"))
}
}
\author{
Yves Croissant
}
