% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch.R
\name{fetch_wards}
\alias{fetch_wards}
\title{Fetch wards}
\usage{
fetch_wards(year = "All", countries = "All")
}
\arguments{
\item{year}{year to filter the locations to, default is "All",
options of 2017, 2019, 2020, 2021, 2022", 2023, 2024}

\item{countries}{vector of desired countries to filter the locations to,
default is "All", or can be a vector with options of "England", "Scotland",
"Wales" or "Northern Ireland"}
}
\value{
data frame of unique location names and codes
}
\description{
Fetch wards
}
\examples{

# Using head() to show only top 5 rows for examples
head(fetch_wards())

head(fetch_pcons())

head(fetch_pcons(2023))

head(fetch_pcons(countries = "Scotland"))

head(fetch_pcons(year = 2023, countries = c("England", "Wales")))

fetch_lads(2024, "Wales")

fetch_las(2022, "Northern Ireland")

# The following have no specific years available and return all values
fetch_regions()
fetch_countries()
}
\seealso{
Other fetch_locations: 
\code{\link{fetch_countries}()},
\code{\link{fetch_lads}()},
\code{\link{fetch_las}()},
\code{\link{fetch_regions}()}
}
\concept{fetch_locations}
