% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile_analysis.R
\name{profiles}
\alias{profiles}
\alias{profile_tables}
\title{Profile analysis}
\usage{
profiles(dataSrc, parms, item_property, predicate = NULL,
  merge_within_persons = FALSE)

profile_tables(parms, domains, item_property, design = NULL)
}
\arguments{
\item{dataSrc}{a connection to a dexter database or a data.frame with columns: person_id, item_id, item_score, 
an arbitrarily named column containing an item property and optionally booklet_id}

\item{parms}{An object returned by \code{\link{fit_enorm}}}

\item{item_property}{the name of the item property used to define the domains. If \code{dataSrc} is a dexter db then the
item_property must match a known item property. If datasrc is a data.frame, item_property must be equal to
 one of its column names. For profile_tables item_property must match a column name in \code{domains}.}

\item{predicate}{An optional expression to subset data in dataSrc, if NULL all data is used}

\item{merge_within_persons}{whether to merge different booklets administered to the same person.}

\item{domains}{data.frame with column item_id and a column with name equal to \code{item_property}}

\item{design}{data.frame with columns item_id and optionally booklet_id}
}
\value{
\describe{
\item{profiles}{a data.frame with columns person_id, booklet_id, booklet_score, 
<item_property>, domain_score, expected_domain_score}
\item{profile_tables}{a data.frame with columns booklet_id, booklet_score, 
<item_property>, expected_domain_score }
}
}
\description{
Expected and observed domain scores, conditional on the test score, per person or test score. 
Domains are specified as categories of items using item_properties.
}
\details{
When using a unidimensional IRT Model like the extended nominal response model in 
dexter (see: \code{\link{fit_enorm}}), the model is as a rule to simple to catch all the relevant dimensions in a test.
Nevertheless, a simple model is quite useful in practice. Profile analysis can complement the model
in this case by indicating how a test-taker, conditional on her/his test score, 
performs on a number of pre-specified domains, e.g. in case of a mathematics test 
the domains could be numbers, algebra and geometry or in case of a digital test the domains could be animated versus
 non-animated items. This can be done by comparing the achieved score on a domain with the expected score, given the test score.
}
\references{
Verhelst, N. D. (2012). Profile analysis: a closer look at the PISA 2000 reading data. 
Scandinavian Journal of Educational Research, 56 (3), 315-332.
}
