% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{damos_08}
\alias{damos_08}
\title{Simplified beta type equation of development rate as a function of temperature.}
\format{
A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation (formula object).}
  \item{eqAlt}{The equation (string).}
  \item{name}{The name of the equation.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameters found in the literature with their references.}
  \item{com}{An optional comment about the equation use.}
  \item{id}{An id to identify the equation.}
}
}
\source{
\url{http://dx.doi.org/10.1093/jee/101.5.1557}
}
\usage{
damos_08
}
\description{
Damos, P.T., and Savopoulou-Soultani, M. (2008). Temperature-dependent bionomics and modeling
of Anarsia lineatella (Lepidoptera: Gelechiidae) in the laboratory.
Journal of economic entomology, 101(5), 1557-1567.
}
\details{
Equation:
\deqn{rT = aa * (bb - \frac{T}{10}) * (\frac{T}{10})^{cc}}{%
      rT = aa * (bb - T / 10) * (T / 10)^cc}

where rT is the development rate, T the temperature, and aa, bb, and
cc empirical constant parameters.
}
\keyword{datasets}
