% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_tileborder.R
\docType{data}
\name{geom_tileborder}
\alias{geom_tileborder}
\alias{StatTileBorder}
\title{Borders between tiles}
\usage{
geom_tileborder(
  mapping = NULL,
  data = NULL,
  geom = "segment",
  position = "identity",
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}
}
\description{
`geom_tileborder` draws a border between tiles of different classes.
The required aesthetics are `aes(x,y,grp)`, where `grp` is the grouping
classification that separates tiles.
}
\details{
Note, we cannot use `aes(group)` because it groups the interaction of
ALL discrete variables including facets.  Since we do not want to draw
a border between facets, we had to define a new aesthetic. 
See: # http://ggplot2.tidyverse.org/reference/aes_group_order.html

Also, we do not want to split the data into separate groups for each level 
of `grp`, so we need to include `aes(group=1)`.
}
\examples{
dd <- data.frame(
  x=c(1,2,1,2,3,1,2,1,2,3),
  y=c(2,2,2,2,2,1,1,1,1,1),
  loc=factor(c(1,1,2,2,2,1,1,2,2,2)),
  rep=factor(c(2,2,1,2,3,1,1,1,2,3)))
library(ggplot2)
ggplot(dd, aes(x=x, y=y)) +
  facet_wrap( ~ loc) +
  geom_tile(aes(fill=rep)) +
  geom_tileborder(aes(group=1, grp=rep), lwd=1.5)
# Compare to lattice version of desplot
# desplot::desplot(rep ~ x*y|loc, data=dd, out1=rep)

}
\keyword{datasets}
