% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{generics}
\alias{generics}
\alias{variance}
\alias{covariance}
\alias{correlation}
\alias{stdev}
\alias{madev}
\alias{modval}
\alias{medial}
\alias{variance.default}
\alias{variance.numeric}
\alias{stdev.default}
\alias{stdev.numeric}
\alias{madev.default}
\alias{quantile.character}
\alias{quantile.factor}
\alias{median.character}
\alias{median.factor}
\alias{mean.character}
\alias{mean.factor}
\alias{pre_print}
\title{Generic functions provided by the statecoaes package}
\usage{
variance(x, ...)

covariance(x, ...)

correlation(x, ...)

stdev(x, ...)

madev(x, ...)

modval(x, ...)

medial(x, ...)

\method{variance}{default}(x, w = NULL, xlast = NULL, xfirst = NULL, ...)

\method{variance}{numeric}(x, w = NULL, ...)

\method{stdev}{default}(x, w = NULL, xlast = NULL, xfirst = NULL, ...)

\method{stdev}{numeric}(x, w = NULL, ...)

\method{madev}{default}(
  x,
  w = NULL,
  center = c("median", "mean"),
  xlast = NULL,
  xfirst = NULL,
  ...
)

\method{quantile}{character}(x, w, probs = c(0.25, 0.5, 0.75), xlast = NULL, xfirst = NULL, ...)

\method{quantile}{factor}(x, w, probs = c(0.25, 0.5, 0.75), xlast = NULL, xfirst = NULL, ...)

\method{median}{character}(x, na.rm, w, xlast = NULL, xfirst = NULL, ...)

\method{median}{factor}(x, na.rm, w, xlast = NULL, xfirst = NULL, ...)

\method{mean}{character}(x, w, xlast = NULL, xfirst = NULL, ...)

\method{mean}{factor}(x, w, xlast = NULL, xfirst = NULL, ...)

pre_print(x)
}
\arguments{
\item{x}{the main argument, basically a character containing the
classes}

\item{...}{further arguments}

\item{w}{a vector of weights}

\item{xlast}{the center of the last class}

\item{xfirst}{the center of the first class}

\item{center}{the center value used to compute the deviations, one
of \code{"median"} or \code{"mean"}}

\item{probs}{a vector of probabilities for the quantile method}

\item{na.rm}{should the missing values be stripped before the
computation of the statistic,}
}
\value{
a numeric or a tibble
}
\description{
Some generics were created, some of them don't exist in base R (to
compute the mode and the mediale of a distribution for example) or
because the functions exist but are not generic (this is the case
of \code{var}, \code{sd}, \code{mad}, \code{cov} and \code{cor} which are replaced by our
\code{variance}, \code{stdev}, \code{madev}, \code{covariance} and \code{correlation}
generic functions
}
\author{
Yves Croissant
}
