% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi-dist.R
\name{chi_plot}
\alias{chi_per}
\alias{chi_plot}
\alias{chi_prob}
\title{Visualize Chi Square Distribution}
\usage{
chi_plot(df = 3, normal = FALSE)

chi_per(probs = 0.95, df = 3, type = c("lower", "upper"))

chi_prob(perc, df, type = c("lower", "upper"))
}
\arguments{
\item{df}{degrees of freedom}

\item{normal}{logical; if \code{TRUE}, normal curve with same \code{mean} and
\code{sd} as the chi square distribution is drawn}

\item{probs}{a probability value}

\item{type}{lower tail or upper tail}

\item{perc}{a quantile value}
}
\value{
percentile for the \code{probs} based on \code{df} and \code{type} or
probability value for \code{perc} based on \code{df} and \code{type}
}
\description{
Visualize how changes in degrees of freedom affect the shape of
the chi square distribution. compute\/visualize quantiles out of given
probability and probability from a given quantile.
}
\examples{
# visualize chi square distribution
chi_plot()
chi_plot(df = 5)
chi_plot(df = 5, normal = TRUE)

# compute\\/visualize quantiles out of given probability
chi_per(0.165, 8, 'upper')
chi_per(0.22, 13, 'upper')

# compute\\/visualize probability from a given quantile.
chi_prob(13.58, 11, 'lower')
chi_prob(15.72, 13, 'upper')
}
\seealso{
\code{\link[stats]{Chisquare}}
}

