
setMethod("fit",
	signature(object="mix"),
	function(object,fixed=NULL,equal=NULL,conrows=NULL,conrows.upper=0,conrows.lower=0,method=NULL,...) {

		# when there are constraints donlp should be used
		# otherwise EM is good
		
		# can/does EM deal with fixed constraints??? it should be possible for sure
 		if(is.null(method)) {
 			if(is.null(equal)&is.null(conrows)&is.null(fixed)) {
 				method="EM"
 			} else {
 				method="donlp"
 			}
 		}
		
		# determine which parameters are fixed
		if(!is.null(fixed)) {
			if(length(fixed)!=npar(object)) stop("'fixed' does not have correct length")
		} else {
			if(!is.null(equal)) {
				if(length(equal)!=npar(object)) stop("'equal' does not have correct length")
				fixed <- !pa2conr(equal)$free
			} else {
				fixed <- getpars(object,"fixed")
			}
		}
		
		# set those fixed parameters in the appropriate submodels
		object <- setpars(object,fixed,which="fixed")
		
		if(is.nan(logLik(object))) stop("Initial model infeasible, log likelihood is NaN; please provide better starting values. ")
		
		if(method=="EM") {
			object <- em(object,verbose=TRUE,...)
		}
		
		if(method=="donlp") {
			# get the full set of parameters
			allpars <- getpars(object)
			# get the reduced set of parameters, ie the ones that will be optimized
			pars <- allpars[!fixed]
			
			# set bounds, if any
			par.u <- rep(+Inf, length(pars))
			par.l <- rep(-Inf, length(pars))
			
			# make loglike function that only depends on pars
			logl <- function(pars) {
				allpars[!fixed] <- pars
				object <- setpars(object,allpars)
				-logLik(object)
			}
			
			if(!require(Rdonlp2)) stop("donlp optimization requires the 'Rdonlp2' package")
			
			# make constraint matrix and its upper and lower bounds
			lincon <- matrix(0,nr=0,nc=npar(object))
			lin.u <- numeric(0)
			lin.l <- numeric(0)
			
			# incorporate equality constraints, if any
			if(!is.null(equal)) {
				if(length(equal)!=npar(object)) stop("'equal' does not have correct length")
				equal <- pa2conr(equal)$conr
				lincon <- rbind(lincon,equal)
				lin.u <- c(lin.u,rep(0,nrow(equal)))
				lin.l <- c(lin.l,rep(0,nrow(equal)))				
			}
			
			# incorporate general linear constraints, if any
			if(!is.null(conrows)) {
				if(ncol(conrows)!=npar(object)) stop("'conrows' does not have the right dimensions")
				lincon <- rbind(lincon,conrows)
				if(any(conrows.upper==0)) {
					lin.u <- c(lin.u,rep(0,nrow(conrows)))
				} else {
					if(length(conrows.upper)!=nrow(conrows)) stop("'conrows.upper does not have correct length")
					lin.u <- c(lin.u,conrows.upper)
				}
				if(any(conrows.lower==0)) {
					lin.l <- c(lin.l,rep(0,nrow(conrows)))
				} else {
					if(length(conrows.lower)!=nrow(conrows)) stop("'conrows.lower does not have correct length")
					lin.l <- c(lin.l,conrows.lower)
				}
			}
				
			# select only those columns of the constraint matrix that correspond to non-fixed parameters
			linconFull <- lincon
			lincon <- lincon[,!fixed,drop=FALSE]
						
			# set donlp2 control parameters
			cntrl <- donlp2.control(hessian=FALSE,difftype=2,report=TRUE)	
			
			mycontrol <- function(info) {
				return(TRUE)
			}
						
			# optimize the parameters
			result <- donlp2(pars,logl,
				par.upper=par.u,
				par.lower=par.l,
				A=lincon,
				lin.upper=lin.u,
				lin.lower=lin.l,
				control=cntrl,
				control.fun=mycontrol,
				...
			)
			
			if(class(object)=="depmix") class(object) <- "depmix.fitted"
			if(class(object)=="mix") class(object) <- "mix.fitted"
			
			object@conMat <- linconFull
			object@message <- result$message
			object@lin.upper <- lin.u
			object@lin.lower <- lin.l
			
			# put the result back into the model
			allpars[!fixed] <- result$par
			object <- setpars(object,allpars)
			
		}
		
		object@posterior <- viterbi(object)
		
		return(object)
	}
)