% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{lazou2016}
\alias{lazou2016}
\title{The serosurvey data in L'Azou 2016}
\format{a data.frame (data.table, if installed) with 20 rows and 4 columns:
\describe{
  \item{Country}{character, common country name (all Peru for this data)}
  \item{Age}{character, the bounding ages for the sample; format: lower age '-' upper age}
  \item{Number}{integer, the number of samples}
  \item{Seropositive}{integer, the number of seropositive samples}
}}
\source{
\url{https://doi.org/10.1056/NEJMoa1503877}
}
\usage{
lazou2016
}
\description{
From "Symptomatic Dengue in Children in 10 Asian and Latin American Countries", Table 4.
}
\examples{
require(denvax); require(ggplot2)
data(lazou2016)
ggplot(lazou2016) + aes(Age, Seropositive/Number*100, color = Country) +
  geom_point() + labs(y="Seropositive \%", x="Age Group") + lims(y=c(0,100)) +
  theme_minimal()
}
\keyword{datasets}
