\name{plotvolu}
\alias{plotvolu}
\title{
Makes a volume plot of a level set tree, a shape plot of a shape tree,
or a tail frequency plot of a tail tree
}
\description{
Plots a volume plot of a level set tree to the graphics window,
or a shape plot of a shape tree, or a tail frequency plot of a tail tree.
}
\usage{
plotvolu(lst, length=NULL,
toplot=TRUE, data=FALSE, crit=NULL, orderrule="distcenter",
modelabel=FALSE, ptext=0, leimat=NULL, symbo=NULL, 
info=NULL, infolift=0, infopos=0,
xmarginleft=0, xmarginright=0, ymargin=0, 
xlim=NULL, ylim=NULL, 
col="black", col.axis="black", 
cutlev=NULL, xaxt="s", yaxt="s",
exmavisu=NULL, bg="transparent", tyyppi="n", lty="solid",colo=FALSE, 
lowest="dens", proba=FALSE,
paletti=NULL, cex=NULL, modecolo = NULL, modepointer = NULL, upper = TRUE,
cex.axis = 1)
}
\arguments{
  \item{lst}{level set tree or shape tree; list of vectors.
   The list contain at least vectors "level", "volume", and "parent". 
   For example, the output of "leafsfirst", "profkern" or "profhist".}
 \item{length}{vector of positive real numbers;
  the length of "length" is equal to the number of nodes of
  the level set tree "lst"; 
  the nodes will be drawn as lines whose length is
  proportional to the corresponding value in vector "length". 
  If length=NULL, then the length of the lines will be
  proportional to the values given in vector "volume" in the list "lst";
  these are the volumes of the sets associated with nodes of the
  level set tree. 
  We may for example apply function "excmas"
  which calculates the excess masses of the nodes and give this vector of
  excess masses as an argument: length=excmas(lst).}
 \item{toplot}{T or F; TRUE if we make a plot, otherwise FALSE.}
  \item{data}{T or F; TRUE if we want the output to contain some
   information, for example an ordering for siblings. 
   This option is needed only by other plotting
   functions of the package, it is not needed by the end user.}
  \item{crit}{d-vector of real numbers; gives a way to control
   the ordering of siblings. The leftmost sibling is the one whose
   barycenter is furthest away from vector "crit".}
  \item{orderrule}{lowel level parameter}
  \item{modelabel}{T or F; TRUE if the modes will be labelled.
   The default is to use labels M1, M2,...}
  \item{ptext}{non-negative real number; the amount by which the mode
   labels will be lifted.}
  \item{leimat}{vector of characters; the length of the vector should be
   equal to the number of modes of the estimate.
   This option is for the case we do not want the ordering of the
   labels to be done automatically.}
  \item{symbo}{character; for example "L". The default value for the
   automatic labelling of the modes is to use M1, M2,...
   With "symbo" we may switch to L1, L2,..., for example.}
  \item{info}{vector of numbers or characters; the length of the vector
   is equal to the number of nodes of the level set tree.
   The elements of "info" will be placed on the right side of the 
   nodes. For example, "info" may be generated by "excmas", or we may
   define "info" to be frequencies of the nodes.
   (Frequencies may be obtained directly from the function "profhist".)}
  \item{infolift}{real number; controls the vertical positioning of
   the elements of "info".}
  \item{infopos}{real number; controls the horizontal positioning of
   the elements of "info". Negative "infopos" will move elements of
   "info" to the right hand side.}
  \item{xmarginleft}{nonnegative real number; adds more margin on the 
   left hand side. The box around the plot will be moved to the left
   with the amount "xmarginleft".}
  \item{xmarginright}{nonnegative real number; adds more margin on the 
   right hand side. The box around the plot will be moved to the right
   with the amount "xmarginright".}
  \item{ymargin}{nonnegative real number; adds more margin on the 
   top of the plot. The box around the plot will be moved up
   with the amount "ymargin".}
  \item{xlim}{vector of 2 real numbers; gives the limits for the scale
   of x-axis.}
  \item{ylim}{vector of 2 real numbers; gives the limits for the scale
   of y-axis.}
  \item{col}{colour for the nodes; for example "black" or "blue".}
  \item{col.axis}{color for the x and y-axis; for example "black" or "blue".}
  \item{cutlev}{positive real number; we may cut the volume plot
   at "cutlev" and thus zoom to the upper levels.}
  \item{xaxt}{a character which specifies the x axis type; either "s" or "n";
   see "par"}
  \item{yaxt}{a character which specifies the y axis type; either "s" or "n";
   see "par"}
  \item{exmavisu}{lower level parameter}
  \item{bg}{lower level parameter}
  \item{tyyppi}{lower level parameter}
  \item{lty}{lower level paremeter}
  \item{colo}{F or T; if T, then the regions under the curve of the volume
  transform/radius transform will be 
  colored with the same color as the corresponding node in the barycenter
  plot/location plot}
  \item{lowest}{if lowest="dens" then the lowest value of y-axis is equal to 0, 
  else the lowest value of y-axis is equal to the minimum of the function;
  this option allows to plot functions with negative values}
  \item{proba}{TRUE, if one wants to plot a tail probability plot of a 
   shape tree}
  \item{paletti}{the colors for the segments of the graph;
   the colors are used to indicate the correspondence with the 
   barycenter plot and thus the paletti should be the same }
  \item{cex}{the magnification factor for the symbols; see "par" }
  \item{modecolo}{internal; used by "scaletable" to set the colors of the leaf
   nodes}
  \item{modepointer}{internal; used by "scaletable" to find the modes}
  \item{upper}{TRUE or FALSE; if upper=TRUE, then a volume plot of an upper
   level set tree is drawn, otherwise a volume plot of a lower level set tree
   is drawn}
  \item{cex.axis}{magnification factor for the axis annotation; see "par"}
 }

\value{A plot is made on the graphics window.}

%\references{http://www.rni.helsinki.fi/~jsk/denpro}
\author{ Jussi Klemela }

\seealso{ 
\code{\link{leafsfirst}},
\code{\link{treedisc}},
\code{\link{prunemodes}},
\code{\link{plotbary}}
\code{\link{plottree}}, 
}

\examples{
# level set tree

dendat<-sim.data(n=100,type="mulmod")
pcf<-pcf.kern(dendat,h=1,N=c(32,32))
lst<-leafsfirst(pcf)             
td<-treedisc(lst,pcf,ngrid=30)

plotvolu(td)

plotvolu(td,ptext=0.002,modelabel=TRUE,symbo="L",colo=TRUE)

# shape tree

dendat<-sim.data(n=100,type="cross")
pcf<-pcf.kern(dendat,h=1,N=c(32,32))
st<-leafsfirst(pcf,propor=0.01)   
td<-treedisc(st,pcf,ngrid=60)

plotvolu(td)

plotvolu(td,proba=TRUE)

# tail tree

tt<-leafsfirst(dendat=dendat,rho=0.65)  
plotvolu(tt)

}

\keyword{multivariate}% at least one, from doc/KEYWORDS
\keyword{hplot}



