% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cal_length.R
\name{cal_length}
\alias{cal_length}
\title{Recursive function to calculate the length of branches}
\usage{
cal_length(x1, x2, subtree, center, nodePar, edgePar, horiz = FALSE, sum)
}
\arguments{
\item{x1}{A x coordinate\code{x1}}

\item{x2}{Another x coordinate\code{x2}}

\item{subtree}{A dendrogram object.\code{subtree}}

\item{center}{A logical whether the dendrogram is centered.\code{center}}

\item{nodePar}{A node parameter.\code{nodePar}}

\item{edgePar}{An edge parameter.\code{edgePar}}

\item{horiz}{A logical about layout.\code{horiz}}

\item{sum}{A sum of length.\code{sum}}
}
\value{
output The length.
}
\description{
\code{cal_length} is a code modified from plotNode()
to calculate the length of lines to draw the branch of a dendrogram. This
function was developed to evaluate the use of ink for visualization.
}
\examples{
#generate sample data
set.seed(1234); par(mar=c(0,0,0,0))
x <- rnorm(10, mean=rep(1:5, each=2), sd=0.4)
y <- rnorm(10, mean=rep(c(1,2), each=5), sd=0.4)
dataFrame <- data.frame(x=x, y=y, row.names=c(1:10))
#calculate Euclidian distance
distxy <- dist(dataFrame)
#hierachical clustering "complete" linkage by default
hc <- hclust(distxy)

total_length <- cal_total_length(as.dendrogram(hc))

}
\keyword{internal}

