\name{fdm}
\alias{fdm}
\title{Functional demographic model}
\usage{fdm(data, series = names(data$rate)[1], order = 6, ages = data$age, 
    max.age = 100, method = c("classical", "M", "rapca"), lambda = 3, 
    mean = TRUE, level = FALSE, transform = TRUE, ...)
}

\arguments{
\item{data}{demogdata object. Output from read.demogdata.}
\item{series}{name of series within data holding rates (1x1)}
\item{order}{Number of basis functions to fit.}
\item{ages}{Ages to include in fit.}
\item{max.age}{Maximum age to fit.}
\item{method}{Method to use for principal components decomposition.
Possibilities are \dQuote{M}, \dQuote{rapca} and \dQuote{classical}. See \code{\link[ftsa]{ftsm}} for details.}
\item{lambda}{Tuning parameter for robustness when \code{method="M"}.}
\item{mean}{If TRUE, will estimate mean term in the model before computing basis terms. If FALSE, the mean term is assumed to be zero.}
\item{level}{If TRUE, will include an additional (intercept) term that depends on the year but not on ages.}
\item{transform}{If TRUE, the data are transformed with a Box-Cox transformation before the model is fitted.}
\item{...}{Extra arguments passed to \code{\link[ftsa]{ftsm}}.}
}

\description{Fits a basis function model to demographic data. The
function uses optimal orthonormal basis functions obtained from a
principal components decomposition.}

\value{Object of class \dQuote{fdm} with the following components:
\item{label}{Name of country}
\item{age}{Ages from \code{data} object.}
\item{year}{Years from \code{data} object.}
\item{<series>}{Matrix of demographic data as contained in \code{data}. It takes the name given by the series argument.}
\item{fitted}{Matrix of fitted values.}
\item{residuals}{Residuals (difference between observed and fitted).}
\item{basis}{Matrix of basis functions evaluated at each age level (one column for each basis function). The first column is the fitted mean.}
\item{coeffs}{Matrix of coefficients (one column for each coefficient series). The first column are all ones.}
\item{mean.se}{Standard errors for the estimated mean function.}
\item{varprop}{Proportion of variation explained by each basis function.}
\item{weights}{Weight associated with each time period.}
\item{v}{Measure of variation for each time period.}
\item{type}{Data type (mortality, fertility, etc.)}
\item{y}{The data stored as a functional time series object.}
}

\author{Rob J Hyndman.}

\references{Hyndman, R.J., and Ullah, S. (2007) Robust forecasting of mortality and
fertility rates: a functional data approach. \emph{Computational Statistics & Data Analysis}, 
\bold{51}, 4942-4956. \url{http://robjhyndman.com/papers/funcfor}
}

\seealso{\code{\link[ftsa]{ftsm}}, \code{\link{forecast.fdm}}}

\examples{
france.fit <- fdm(fr.mort)
summary(france.fit)
plot(france.fit)
plot(residuals(france.fit))
}
\keyword{models}
