/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.mgf;

import ch.fgcz.proteomics.dto.MassSpecMeasure;
import ch.fgcz.proteomics.dto.MassSpecMeasureSerializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReadStdIn {
    private static final Logger LOGGER = Logger.getLogger(MassSpecMeasureSerializer.class.getName());

    private ReadStdIn() {
        throw new IllegalStateException("Reader (standart in) class");
    }

    public static MassSpecMeasure read() {
        InputStreamReader inputStreamReader = new InputStreamReader(System.in);
        MassSpecMeasure massSpectrometryMeasurement = new MassSpecMeasure(null);
        try (BufferedReader bufferedreader = new BufferedReader(inputStreamReader);){
            String line = "";
            int chargeState = 0;
            int id = 0;
            double peptidMass = 0.0;
            ArrayList<Double> mz = new ArrayList<Double>();
            ArrayList<Double> intensity = new ArrayList<Double>();
            while ((line = bufferedreader.readLine()) != null) {
                String[] partEqual = line.split("=");
                String[] partSpace = line.split(" ");
                if (line.equals("BEGIN IONS")) {
                    chargeState = 0;
                    id = massSpectrometryMeasurement.getMSlist().size();
                    peptidMass = 0.0;
                    mz = new ArrayList();
                    intensity = new ArrayList();
                    continue;
                }
                if (line.equals("END IONS")) {
                    massSpectrometryMeasurement.addMS(mz, intensity, peptidMass, chargeState, id);
                    continue;
                }
                if (line.contains("CHARGE")) {
                    chargeState = Integer.parseInt(partEqual[1].substring(0, 1));
                    continue;
                }
                if (line.contains("PEPMASS")) {
                    String[] pepmasssplit = partEqual[1].split(" ");
                    peptidMass = Double.parseDouble(pepmasssplit[0]);
                    continue;
                }
                if (partSpace.length <= 1 || !ReadStdIn.isDouble(partSpace[0]) || !ReadStdIn.isDouble(partSpace[1])) continue;
                mz.add(Double.parseDouble(partSpace[0]));
                intensity.add(Double.parseDouble(partSpace[1]));
            }
        }
        catch (IOException e2) {
            LOGGER.log(Level.SEVERE, e2.toString(), e2);
        }
        return massSpectrometryMeasurement;
    }

    private static boolean isDouble(String string) {
        Scanner scanner = new Scanner(string);
        boolean b = scanner.hasNextDouble();
        scanner.close();
        return b;
    }
}

