/*
 * Decompiled with CFR 0.152.
 */
package ch.fgcz.proteomics.fbdm;

import ch.fgcz.proteomics.fbdm.Configuration;
import ch.fgcz.proteomics.fbdm.Connection;
import ch.fgcz.proteomics.fbdm.IsotopicCluster;
import ch.fgcz.proteomics.fbdm.Peak;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;

public class ScoreFive {
    private DefaultDirectedWeightedGraph<IsotopicCluster, Connection> isotopicClusterGraph;
    private Configuration config;

    public ScoreFive(DefaultDirectedWeightedGraph<IsotopicCluster, Connection> isotopicClusterGraph, Configuration config) {
        this.isotopicClusterGraph = isotopicClusterGraph;
        this.config = config;
    }

    public double calculateFifthScore(Connection connection) {
        return this.config.getF5() * (double)ScoreFive.calculateScoreBasedOnExperimentalIsotopicDistribution(connection, this.isotopicClusterGraph, this.config);
    }

    public static int calculateScoreBasedOnExperimentalIsotopicDistribution(Connection connection, DefaultDirectedWeightedGraph<IsotopicCluster, Connection> isotopicClusterGraph, Configuration config) {
        int F5 = 0;
        double threshold = 0.3;
        int i = 0;
        for (Peak p : ((IsotopicCluster)isotopicClusterGraph.getEdgeTarget((Object)connection)).getIsotopicCluster()) {
            double tMin = p.getMz() / config.getASP_MASS() * p.getIntensity();
            double tMean = p.getMz() / config.getAVE_UPDATED_MASS() * p.getIntensity();
            double tMeanOverlap = 0.0;
            if (((IsotopicCluster)isotopicClusterGraph.getEdgeSource((Object)connection)).isNotNull()) {
                tMeanOverlap = i < ((IsotopicCluster)isotopicClusterGraph.getEdgeSource((Object)connection)).size() ? ((IsotopicCluster)isotopicClusterGraph.getEdgeSource((Object)connection)).getPeak(i).getMz() / config.getAVE_UPDATED_MASS() * p.getIntensity() : ((IsotopicCluster)isotopicClusterGraph.getEdgeSource((Object)connection)).getPeak(((IsotopicCluster)isotopicClusterGraph.getEdgeSource((Object)connection)).size() - 1).getMz() / config.getAVE_UPDATED_MASS() * p.getIntensity();
            }
            double tMax = p.getMz() / config.getPHE_MASS() * p.getIntensity();
            if (connection.getColor() == "black" && Math.min(Math.abs(p.getIntensity() - tMin), Math.abs(p.getIntensity() - tMax)) / tMean <= threshold) {
                ++F5;
            }
            if (connection.getColor() == "red" && Math.min(Math.abs(p.getIntensity() - tMeanOverlap - tMin), Math.abs(p.getIntensity() - tMeanOverlap - tMax)) / tMean <= threshold) {
                ++F5;
            }
            ++i;
        }
        return F5;
    }
}

